<?php

defined('ABSPATH') || exit;

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option('theme-custom-color'));
$theme_gradient_start = GenesisExpo_Theme_Helper::get_option('theme-gradient')['from'] ?? '';
$theme_gradient_end = GenesisExpo_Theme_Helper::get_option('theme-gradient')['to'] ?? '';
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');

if (function_exists('vc_map')) {
    vc_map([
        'base' => 'wgl_video_popup',
        'name' => esc_html__('Video Popup', 'genesisexpo'),
        'description' => esc_html__('Create a Button or Poster for Video Popup.', 'genesisexpo'),
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_video_popup',
        'params' => [
            [
                'type' => 'textfield',
                'heading' => esc_html__('Title', 'genesisexpo'),
                'param_name' => 'title',
            ],
            [
                'type' => 'dropdown',
                'heading' => esc_html__('Title Position', 'genesisexpo'),
                'param_name' => 'title_pos',
                'value' => [
                    esc_html__('Left', 'genesisexpo') => 'left',
                    esc_html__('Right', 'genesisexpo')  => 'right',
                    esc_html__('Top', 'genesisexpo') => 'top',
                    esc_html__('Bottom', 'genesisexpo') => 'bot',
                ],
                'std' => 'bot',
            ],
            [
                'type' => 'dropdown',
                'heading' => esc_html__('Video Popup Button Alignment', 'genesisexpo'),
                'param_name' => 'button_pos',
                'value' => [
                    esc_html__('Left', 'genesisexpo') => 'left',
                    esc_html__('Center', 'genesisexpo')  => 'center',
                    esc_html__('Right', 'genesisexpo') => 'right',
                    esc_html__('Inline', 'genesisexpo')  => 'inline',
                ],
                'std' => 'center',
            ],
            [
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Always Pulse Animation on Button', 'genesisexpo'),
                'param_name' => 'always_pulse_anim',
            ],
            [
                'type' => 'textfield',
                'heading' => esc_html__('Video Link', 'genesisexpo'),
                'param_name' => 'link',
                'description' => esc_html__('Enter video link from youtube or vimeo.', 'genesisexpo')
            ],
            [
                'type' => 'attach_image',
                'heading' => esc_html__('Background Image Video', 'genesisexpo'),
                'param_name' => 'bg_image',
                'description' => esc_html__('Select video background image.', 'genesisexpo')
            ],
            vc_map_add_css_animation(true),
            [
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ],
            [
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Title Styles', 'genesisexpo'),
                'param_name' => 'h_background_title_styles',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Title color', 'genesisexpo'),
                'param_name' => 'title_color',
                'value' => '#ffffff',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom font family for Video Popup title?', 'genesisexpo'),
                'param_name' => 'custom_fonts_title',
                'description' => esc_html__('Customize font family', 'genesisexpo'),
                'group' => esc_html__('Styling', 'genesisexpo'),
            ],
            [
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_title',
                'value' => '',
                'dependency' => [
                    'element' => 'custom_fonts_title',
                    'value' => 'true',
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
            ],
            [
                'type' => 'textfield',
                'heading' => esc_html__('Video Popup Title Font Size', 'genesisexpo'),
                'param_name' => 'title_size',
                'value' => '14',
                'description' => esc_html__('Enter Video Popup Title font-size in pixels.', 'genesisexpo'),
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Styles', 'genesisexpo'),
                'param_name' => 'h_background_title_styles',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-12',
            ],
            // Background color/gradient
            [
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Triangle Size', 'genesisexpo'),
                'param_name' => 'custom_triangle_size',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'textfield',
                'heading' => esc_html__('Triangle Size', 'genesisexpo'),
                'param_name' => 'triangle_size',
                'description' => esc_html__('Enter triangle size in pixels.', 'genesisexpo'),
                'group' => esc_html__('Styling', 'genesisexpo'),
                'dependency' => [
                    'element' => 'custom_triangle_size',
                    'value' => 'true',
                ],
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Triangle Color', 'genesisexpo'),
                'param_name' => 'custom_button_color',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',

            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Triangle color', 'genesisexpo'),
                'param_name' => 'button_color',
                'value' => '#ffffff',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'dependency' => [
                    'element' => 'custom_button_color',
                    'value' => 'true',
                ],
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'dropdown',
                'heading' => esc_html__('Background Customize Colors', 'genesisexpo'),
                'param_name' => 'bg_color_type',
                'value' => [
                    esc_html__('Default', 'genesisexpo')  => 'def',
                    esc_html__('Color', 'genesisexpo') => 'color',
                    esc_html__('Gradient', 'genesisexpo') => 'gradient',
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Color', 'genesisexpo'),
                'param_name' => 'background_color',
                'value' => $theme_color,
                'description' => esc_html__('Select background color', 'genesisexpo'),
                'dependency' => [
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Start Color', 'genesisexpo'),
                'param_name' => 'background_gradient_start',
                'value' => $theme_gradient_start,
                'dependency' => [
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Background End Color', 'genesisexpo'),
                'param_name' => 'background_gradient_end',
                'value' => $theme_gradient_end,
                'dependency' => [
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-6',
            ],
            // Animation Styles
            [
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Animation Styles', 'genesisexpo'),
                'param_name' => 'animated_circles_styles',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-12',
            ],
            [
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Custom Animation Color', 'genesisexpo'),
                'param_name' => 'custom_animation_color',
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
            ],
            [
                'type' => 'colorpicker',
                'heading' => esc_html__('Animation Color', 'genesisexpo'),
                'param_name' => 'animation_color',
                'value' => '#7c529c',
                'dependency' => [
                    'element' => 'custom_animation_color',
                    'value' => 'true'
                ],
                'group' => esc_html__('Styling', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
            ], // \Animation Styles
        ],
    ]);

    class WPBakeryShortCode_wgl_Video_Popup extends WPBakeryShortCode
    {
    }
}
