<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Time Line Horizontal', 'genesisexpo'),
        'base' => 'wgl_time_line_horizontal',
        'class' => 'genesisexpo_time_line_horizontal',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_horizont-timeline',
        'content_element' => true,
        'description' => esc_html__('Display Time Line Horizontal','genesisexpo'),
        'params' => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Time Line Items Content', 'genesisexpo' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph - title, description, date and color.', 'genesisexpo' ),
                'params' => array(
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__( 'Date', 'genesisexpo' ),
                        "param_name"    => "date",
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__( 'Title', 'genesisexpo' ),
                        "param_name"    => "title",
                    ),
                    array(
                        "type"          => "textarea",
                        "heading"       => esc_html__( 'Description', 'genesisexpo' ),
                        "param_name"    => "descr",
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__('Circle Color', 'genesisexpo'),
                        'param_name' => 'circle_color',
                        'value' => $theme_color,
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                ),
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // Carousel
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Carousel for Time Line Items', 'genesisexpo'),
                'param_name' => 'h_carousel',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__( 'Items to Show', 'genesisexpo' ),
                "param_name"    => "slide_to_show",
                "value"         => array(
                    esc_html__( '1', 'genesisexpo' )    => '1',
                    esc_html__( '2', 'genesisexpo' )   => '2',
                    esc_html__( '3', 'genesisexpo' ) => '3',
                    esc_html__( '4', 'genesisexpo' )  => '4',
                    esc_html__( '5', 'genesisexpo' )  => '5',
                    esc_html__( '6', 'genesisexpo' )  => '6',
                ),           
                'std' => '5',   
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Single slide to scroll', 'genesisexpo' ),
                'param_name' => 'slides_to_scroll',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Infinite loop sliding', 'genesisexpo' ),
                'param_name' => 'infinite',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                "type"          => "wgl_checkbox",
                'heading' => esc_html__( 'Autoplay', 'genesisexpo' ),
                "param_name"    => "autoplay",
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__( 'Autoplay Speed', 'genesisexpo' ),
                "param_name"    => "autoplay_speed",
                "dependency"    => array(
                    "element"   => "autoplay",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                "value"         => "3000",
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Pagination Controls', 'genesisexpo'),
                'param_name' => 'h_pag_controls',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Pagination control', 'genesisexpo' ),
                'param_name' => 'use_pagination',
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'std' => 'true'
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Pagination Type', 'genesisexpo'),
                'param_name' => 'pag_type',
                'fields' => array(
                    'circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle.png',
                        'label' => esc_html__('Circle', 'genesisexpo')),
                    'circle_border' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle_border.png',
                        'label' => esc_html__('Empty Circle', 'genesisexpo')),
                    'square' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_square.png',
                        'label' => esc_html__('Square', 'genesisexpo')),
                    'line' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line.png',
                        'label' => esc_html__('Line', 'genesisexpo')),
                    'line_circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line_circle.png',
                        'label' => esc_html__('Line - Circle', 'genesisexpo')),
                ),
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'value' => 'circle',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Pagination Top Offset', 'genesisexpo' ),
                'param_name' => 'pag_offset',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Enter pagination top offset in pixels.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Pagination Aligning', 'genesisexpo'),
                'param_name' => 'pag_align',
                'value' => array(
                    esc_html__('Left', 'genesisexpo') => 'left',
                    esc_html__('Right', 'genesisexpo') => 'right',
                    esc_html__('Center', 'genesisexpo') => 'center',
                ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'std' => 'center',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Pagination Color', 'genesisexpo' ),
                'param_name' => 'custom_pag_color',
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Pagination Color', 'genesisexpo'),
                'param_name' => 'pag_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_pag_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Responsive', 'genesisexpo'),
                'param_name' => 'h_resp',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Customize Responsive', 'genesisexpo' ),
                'param_name' => 'custom_resp',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            // medium desktop
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Medium Desktop', 'genesisexpo'),
                'param_name' => 'h_resp_medium',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_medium',
                'value' => '1025',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_medium_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            
            // tablets
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Tablets', 'genesisexpo'),
                'param_name' => 'h_resp_tablets',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_tablets',
                'value' => '800',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_tablets_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            // mobile phones
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Mobile Phones', 'genesisexpo'),
                'param_name' => 'h_resp_mobile',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_mobile',
                'value' => '480',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_mobile_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Time_Line_Horizontal extends WPBakeryShortCode {
        }
    }
}
