<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Progress Bar', 'genesisexpo'),
        'base' => 'wgl_progress_bar',
        'class' => 'genesisexpo_progress_bar',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_progress_bar',
        'content_element' => true,
        'description' => esc_html__('Display Progress Bar','genesisexpo'),
        'params' => array(
            array(
                'type' => 'param_group',
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph - point label and point value.', 'genesisexpo' ),
                'params' => array(
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__( 'Label', 'genesisexpo' ),
                        "param_name"    => "label",
                        'admin_label'   => true,
                        "description"    => esc_html__( 'Enter text used as title of bar.', 'genesisexpo' ),
                    ),
                    array(
                        "type"          => "textfield",
                        "heading"       => esc_html__( 'Value', 'genesisexpo' ),
                        "param_name"    => "point_value",
                        "description"    => esc_html__( 'Enter value of bar.', 'genesisexpo' ),
                    ),
                    array(
                        'type'          => 'dropdown',
                        'heading'       => esc_html__( 'Progress Bar Customize Color', 'genesisexpo' ),
                        'param_name'    => 'bar_color_type',
                        'value'         => array(
                            esc_html__( 'Default', 'genesisexpo' )      => 'def',
                            esc_html__( 'Color', 'genesisexpo' )      => 'color',
                        ),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__('Text Color', 'genesisexpo'),
                        'param_name' => 'text_color',
                        'value' => $header_font['color'],
                        'description' => esc_html__('Select text color', 'genesisexpo'),
                        'dependency' => array(
                            'element' => 'bar_color_type',
                            'value' => 'color'
                        ),
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__('Bar Color', 'genesisexpo'),
                        'param_name' => 'bar_color',
                        'value' => $theme_color,
                        'description' => esc_html__('Select bar color', 'genesisexpo'),
                        'dependency' => array(
                            'element' => 'bar_color_type',
                            'value' => 'color'
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        'type' => 'colorpicker',
                        'heading' => esc_html__('Background Bar Color', 'genesisexpo'),
                        'param_name' => 'bg_bar_color',
                        'value' => '#e8e9f2',
                        'description' => esc_html__('Select background bar color', 'genesisexpo'),
                        'dependency' => array(
                            'element' => 'bar_color_type',
                            'value' => 'color'
                        ),
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                ),
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__( 'Units', 'genesisexpo' ),
                "param_name"    => "units",
                'value' => '%',
                'description' => esc_html__('Enter measurement units (Example: %, px, points, etc. Note: graph value and units will be appended to graph title).', 'genesisexpo'),
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Progress_Bar extends WPBakeryShortCode {
        }
    }
}
