<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$theme_color			= esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$theme_color_secondary	= esc_attr(GenesisExpo_Theme_Helper::get_option("theme-secondary-color"));
$header_font_color		= GenesisExpo_Theme_Helper::get_option('header-font')['color'];
$main_font_color		= GenesisExpo_Theme_Helper::get_option('main-font')['color'];


if (function_exists('vc_map')) {
	vc_map(array(
		'name' => esc_html__('Pricing Table', 'genesisexpo'),
		'base' => 'wgl_pricing_table',
		'class' => 'genesisexpo_pricing_table',
		'category' => esc_html__('WGL Modules', 'genesisexpo'),
		'icon' => 'wgl_icon_price_table',
		'content_element' => true,
		'description' => esc_html__('Display Pricing Table','genesisexpo'),
		'params' => array(
			// GENERAL TAB
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Pricing Table Title', 'genesisexpo'),
				'param_name' => 'pricing_title',
				'admin_label' => true,
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Currency', 'genesisexpo'),
				'param_name' => 'pricing_cur',
				'edit_field_class' => 'vc_col-sm-2',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Price', 'genesisexpo'),
				'param_name' => 'pricing_price',
				'edit_field_class' => 'vc_col-sm-2',
				'admin_label' => true,
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Descriptions', 'genesisexpo'),
				'param_name' => 'pricing_desc',
				'edit_field_class' => 'vc_col-sm-8',
			),
			vc_map_add_css_animation( true ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Extra Class', 'genesisexpo'),
				'param_name' => 'extra_class',
				'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
			),
			// ICON TAB
			// Pricing Table Icon/Image heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Icon Type', 'genesisexpo'),
				'param_name' => 'h_icon_type',
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
			),
			// Pricing Table Icon/Image
			array(
				'type'          => 'dropdown',
				'param_name'    => 'icon_type',
				'value'         => array(
					esc_html__( 'None', 'genesisexpo' )      => 'none',
					esc_html__( 'Font', 'genesisexpo' )      => 'font',
					esc_html__( 'Image', 'genesisexpo' )     => 'image',
				),
				'save_always' => true,
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
			),
			array(
				'type'          => 'dropdown',
				'param_name'    => 'icon_font_type',
				'value'         => array(
					esc_html__( 'Fontawesome', 'genesisexpo' )      => 'type_fontawesome',
					esc_html__( 'Flaticon', 'genesisexpo' )      => 'type_flaticon',
				),
				'save_always' => true,
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'font',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'genesisexpo' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an 'EMPTY' icon?
					'iconsPerPage' => 200,
					// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
				),
				'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_font_type',
					'value' => 'type_fontawesome',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'genesisexpo' ),
				'param_name' => 'icon_flaticon',
				'value' => '', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					// default true, display an 'EMPTY' icon?
					'type' => 'flaticon',
					'iconsPerPage' => 200,
					// default 100, how many icons per/page to display, we use (big number) to display all icons in single page
				),
				'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_font_type',
					'value' => 'type_flaticon',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
			),
			array(
				'type' => 'attach_image',
				'heading' => esc_html__( 'Image', 'genesisexpo' ),
				'param_name' => 'thumbnail',
				'value' => '',
				'description' => esc_html__( 'Select image from media library.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'image',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
			),
			// Custom image width
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Custom Image Width', 'genesisexpo'),
				'param_name' => 'custom_image_width',
				'description' => esc_html__( 'Enter image size in pixels.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'image',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Custom image height
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Custom Image Height', 'genesisexpo'),
				'param_name' => 'custom_image_height',
				'description' => esc_html__( 'Enter image size in pixels.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'image',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Custom icon size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Custom Icon Size', 'genesisexpo'),
				'param_name' => 'custom_icon_size',
				'description' => esc_html__( 'Enter Icon size in pixels.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'font',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-3',
			),
			// Icon color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Icon Colors', 'genesisexpo' ),
				'param_name' => 'custom_icon_color',
				'description' => esc_html__( 'Select custom colors', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'font',
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// Icon color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Icon Color', 'genesisexpo'),
				'param_name' => 'icon_color',
				'value' => '#ffffff',
				'description' => esc_html__('Select icon color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_icon_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Icon', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-5',
			),   
			// CONTENT TAB
			array(
				'type' => 'textarea_html',
				'holder' => 'div',
				'heading' => esc_html__('Content.', 'genesisexpo'),
				'param_name' => 'content',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'admin_label' => false,
			),
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Add Button', 'genesisexpo'),
				'param_name' => 'h_button',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			// Button text
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'genesisexpo'),
				'param_name' => 'button_title',
				'value' => esc_html__('Get Ticket', 'genesisexpo'),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
			),
			// Button link
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Button Link', 'genesisexpo' ),
				'param_name' => 'link',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'description' => esc_html__('Add link to button.', 'genesisexpo')
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Customize', 'genesisexpo' ),
				'param_name' => 'button_customize',
				'value'         => array(
					esc_html__( 'Default', 'genesisexpo' ) => 'def',
					esc_html__( 'Color', 'genesisexpo' )   => 'color',
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
			),
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Text Color', 'genesisexpo'),
				'param_name' => 'h_text_color',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => 'color'
				),
			),
			// Button text color idle
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Text Color', 'genesisexpo'),
				'param_name' => 'button_text_color',
				'value' => '#ffffff',
				'description' => esc_html__('Select custom text color for button.', 'genesisexpo'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => 'color'
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button text color hover
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Text Color', 'genesisexpo'),
				'param_name' => 'button_text_color_hover',
				'value' => $theme_color_secondary,
				'description' => esc_html__('Select custom text color for hover button.', 'genesisexpo'),
				'dependency' => array(
					'element' => 'button_customize',
					'value' => 'color',
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button bg header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Background Color', 'genesisexpo'),
				'param_name' => 'h_background_color',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
			),
			// Button Bg
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Background', 'genesisexpo'),
				'param_name' => 'button_bg_color',
				'value' => $theme_color_secondary,
				'description' => esc_html__('Select custom background for button.', 'genesisexpo'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Hover Bg
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Background', 'genesisexpo'),
				'param_name' => 'button_bg_color_hover',
				'value' => '#ffffff',
				'description' => esc_html__('Select custom background for hover button.', 'genesisexpo'),
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Bg Gradient header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Background Gradient Color', 'genesisexpo'),
				'param_name' => 'h_button_background_gradient_color',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
			),
			// Button Bg Gradient start
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Start Color', 'genesisexpo'),
				'param_name' => 'button_bg_gradient_start',
				'value' => '#f8f9fd',
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Bg Gradient end
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('End Color', 'genesisexpo'),
				'param_name' => 'button_bg_gradient_end',
				'value' => '#f8f9fd',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Bg Gradient Hover header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Background Gradient Hover Color', 'genesisexpo'),
				'param_name' => 'h_background_gradient_hover_color',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
			),
			// Button Bg Gradient Hover start
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Start Color', 'genesisexpo'),
				'param_name' => 'button_bg_gradient_start_hover',
				'value' => '#ffffff',
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Bg Gradient Hover end
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('End Color', 'genesisexpo'),
				'param_name' => 'button_bg_gradient_end_hover',
				'value' => '#ffffff',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('gradient')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button border-color header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Border Color', 'genesisexpo'),
				'param_name' => 'h_border_color',
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
			),
			// Button border-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Border Color', 'genesisexpo'),
				'param_name' => 'button_border_color',
				'value' => $theme_color_secondary,
				'description' => esc_html__('Select custom border color for button.', 'genesisexpo'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Hover border-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Border Color', 'genesisexpo'),
				'param_name' => 'button_border_color_hover',
				'value' => $theme_color_secondary,
				'description' => esc_html__('Select custom border color for hover button.', 'genesisexpo'),
				'group' => esc_html__( 'Content', 'genesisexpo' ),
				'save_always' => true,
				'dependency' => array(
					'element' => 'button_customize',
					'value' => array('color')
				),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Background styling
			array(
				'type' 		 => 'genesisexpo_param_heading',
				'heading' 	 => esc_html__('Header Background', 'genesisexpo'),
				'param_name' => 'h_header_style',
				'group' 	 => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
			),
			array(
				'type'		 => 'dropdown',
				'heading'	 => esc_html__( 'Customize', 'genesisexpo' ),
				'param_name' => 'header_customize',
				'value'		 => array(
					esc_html__( 'Default', 'genesisexpo' ) => 'def',
					esc_html__( 'Color', 'genesisexpo' )   => 'color',
					esc_html__( 'Image', 'genesisexpo' )   => 'image',
				),
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6 no-top-margin',
			),
			// Header bg
			array(
				'type' 		  => 'colorpicker',
				'class'		  => '',
				'heading' 	  => esc_html__('Background', 'genesisexpo'),
				'param_name'  => 'header_bg_color',
				'value' 	  => $theme_color_secondary,
				'description' => esc_html__('Select custom background for header.', 'genesisexpo'),
				'save_always' => true,
				'dependency'  => array(
					'element' => 'header_customize',
					'value' => array('color')
				),
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Header bg gradient
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Background Gradient Color', 'genesisexpo'),
				'param_name' => 'h_background_gradient_color',
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'header_customize',
					'value' => array('gradient')
				),
			),
			// Header bg image
			array(
				'type'		  => 'attach_image',
				'heading'	  => esc_html__( 'Background Header Image', 'genesisexpo' ),
				'param_name'  => 'bg_image',
				'value'		  => '',
				'description' => esc_html__( 'Select image from media library.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'header_customize',
					'value' => 'image',
				),
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Ticket punch bg color
			array(
				'type' 		  => 'colorpicker',
				'class'		  => '',
				'heading' 	  => esc_html__('Ticket punch background', 'genesisexpo'),
				'param_name'  => 'pricing_punch_bg_color',
				'value' 	  => '#ffffff',
				'description' => esc_html__('Select custom background.', 'genesisexpo'),
				'save_always' => true,
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			array(
				'type' 		 => 'genesisexpo_param_heading',
				'heading' 	 => esc_html__('Content Background', 'genesisexpo'),
				'param_name' => 'h_content_style',
				'group' 	 => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			array(
				'type'		 => 'dropdown',
				'heading'	 => esc_html__( 'Customize', 'genesisexpo' ),
				'param_name' => 'content_customize',
				'value'		 => array(
					esc_html__( 'Default', 'genesisexpo' ) => 'def',
					esc_html__( 'Color', 'genesisexpo' )   => 'color',
				),
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6 no-top-margin',
			),
			// Content bg color
			array(
				'type' 		  => 'colorpicker',
				'class'		  => '',
				'heading' 	  => esc_html__('Background', 'genesisexpo'),
				'param_name'  => 'content_bg_color',
				'value' 	  => '#ffffff',
				'description' => esc_html__('Select custom background for content.', 'genesisexpo'),
				'save_always' => true,
				'dependency'  => array(
					'element' => 'content_customize',
					'value' => array('color')
				),
				'group' => esc_html__( 'Background', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// title styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Title Styles', 'genesisexpo'),
				'param_name' => 'h_title_styles',
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
			),
			// title Font Size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Size', 'genesisexpo'),
				'param_name' => 'title_size',
				'value' => '',
				'description' => esc_html__( 'Enter title font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// title Font Weight
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Title Font Weight', 'genesisexpo'),
				'param_name' => 'title_weight',
				'value' => '',
				'description' => esc_html__( 'Enter font-weight.', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Title Fonts
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Custom font family for pricing table title', 'genesisexpo' ),
				'param_name' => 'custom_fonts_title',
				'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts_title',
				'value' => '',
				'dependency' => array(
					'element' => 'custom_fonts_title',
					'value' => 'true',
				),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
			),
			// title color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Title Color', 'genesisexpo' ),
				'param_name' => 'custom_title_color',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// title color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Title Color', 'genesisexpo'),
				'param_name' => 'title_color',
				'value' => '#ffffff',
				'description' => esc_html__('Select title color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_title_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// heading title styles 
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Price Styles', 'genesisexpo'),
				'param_name' => 'h_content_styles',
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			// content Font Size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Price Font Size', 'genesisexpo'),
				'param_name' => 'price_size',
				'value' => '',
				'description' => esc_html__( 'Enter price font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Price Color', 'genesisexpo' ),
				'param_name' => 'custom_price_color',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// title color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Price Color', 'genesisexpo'),
				'param_name' => 'price_color',
				'value' => $header_font_color,
				'description' => esc_html__('Select price color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_price_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// Pricing Description Styles
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Pricing Descriptions Styles', 'genesisexpo'),
				'param_name' => 'description_styles',
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			// Pricing description font size 
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Pricing Description Font Size', 'genesisexpo'),
				'param_name' => 'description_size',
				'value' => '',
				'description' => esc_html__( 'Enter description font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			//  Pricing description custom color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Description Color', 'genesisexpo' ),
				'param_name' => 'custom_description_color',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// Pricing description custom color picker
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Description Color', 'genesisexpo'),
				'param_name' => 'description_color',
				'value' => $main_font_color,
				'description' => esc_html__('Select price color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_description_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Typography', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
		)
	));

	if (class_exists('WPBakeryShortCode')) {
		class WPBakeryShortCode_wgl_Pricing_Table extends WPBakeryShortCode {}
	}
}
