<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');

if (function_exists('vc_map')) {
// Add list item
    vc_map(array(
        'name' => esc_html__('Double Headings', 'genesisexpo'),
        'base' => 'wgl_double_headings',
        'class' => 'genesisexpo_custom_text',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_double-text',
        'content_element' => true,
        'description' => esc_html__('Double Headings','genesisexpo'),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title', 'genesisexpo'),
                'param_name' => 'title',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Subtitle', 'genesisexpo'),
                'param_name' => 'subtitle',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Background Title', 'genesisexpo'),
                'param_name' => 'bgtitle',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Alignment', 'genesisexpo' ),
                'param_name' => 'align',
                'edit_field_class' => 'vc_col-sm-12',
                'value' => array(
                    esc_html__( 'Left', 'genesisexpo' )   => 'left',
                    esc_html__( 'Right', 'genesisexpo' )  => 'right',
                    esc_html__( 'Center', 'genesisexpo' ) => 'center',
                ),
            ), 
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // TITLE STYLES TAB
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Title Styles', 'genesisexpo'),
                'param_name' => 'h_title_styles',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Title Tag', 'genesisexpo' ),
                'param_name' => 'title_tag',
                'value' => array(
                    esc_html__( 'div', 'genesisexpo' ) => 'div',
                    esc_html__( 'h2', 'genesisexpo' )  => 'h2',
                    esc_html__( 'h3', 'genesisexpo' )  => 'h3',
                    esc_html__( 'h4', 'genesisexpo' )  => 'h4',
                    esc_html__( 'h5', 'genesisexpo' )  => 'h5',
                    esc_html__( 'h6', 'genesisexpo' )  => 'h6',
                ),
                'std' => 'div',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Your html tag for title', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title Font Size', 'genesisexpo'),
                'param_name' => 'title_size',
                'value' => '40px',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title Line Height', 'genesisexpo'),
                'param_name' => 'title_line_height',
                'value' => '52px',
                'description' => esc_html__( 'Enter line height in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Title Font Weight', 'genesisexpo' ),
                'param_name' => 'title_weight',
                'value' => array(
                    esc_html__( '300 / Light', 'genesisexpo' )      => '300',
                    esc_html__( '400 / Regular', 'genesisexpo' )    => '400',
                    esc_html__( '500 / Medium', 'genesisexpo' )     => '500',
                    esc_html__( '600 / SemiBold', 'genesisexpo' )   => '600',
                    esc_html__( '700 / Bold', 'genesisexpo' )       => '700',
                    esc_html__( '800 / Extra-Bold', 'genesisexpo' ) => '800',
                ),
                'std' => '500',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Custom title weight', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Title Color', 'genesisexpo' ),
                'param_name' => 'custom_title_color',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Title Color', 'genesisexpo' ),
                'param_name' => 'title_color',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'value' => esc_attr($header_font['color']),
                'save_always' => true,
                'dependency' => array(
                    'element' => 'custom_title_color',
                    'value' => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Choose color for title.', 'genesisexpo' ),
            ), 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Set Title Resonsive Font Size', 'genesisexpo' ),
                'param_name' => 'responsive_font',
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Small Desktops', 'genesisexpo'),
                'param_name' => 'font_size_desctop',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Tablets', 'genesisexpo'),
                'param_name' => 'font_size_tablet',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Mobile', 'genesisexpo'),
                'param_name' => 'font_size_mobile',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for title', 'genesisexpo' ),
                'param_name' => 'custom_fonts_title',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_title',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_title',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Title Styles', 'genesisexpo' ),
            ),   
            // SUBTITLE STYLES TAB
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Subtitle Styles', 'genesisexpo'),
                'param_name' => 'h_subtitle_styles',
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Subtitle Tag', 'genesisexpo' ),
                'param_name' => 'subtitle_tag',
                'value' => array(
                    esc_html__( 'div', 'genesisexpo' ) => 'div',
                    esc_html__( 'h2', 'genesisexpo' )  => 'h2',
                    esc_html__( 'h3', 'genesisexpo' )  => 'h3',
                    esc_html__( 'h4', 'genesisexpo' )  => 'h4',
                    esc_html__( 'h5', 'genesisexpo' )  => 'h5',
                    esc_html__( 'h6', 'genesisexpo' )  => 'h6',
                ),
                'std' => 'div',
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Your html tag for subtitle', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Subtitle Font Size', 'genesisexpo'),
                'param_name' => 'subtitle_size',
                'value' => '22px',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Subtitle Line Height', 'genesisexpo'),
                'param_name' => 'subtitle_line_height',
                'value' => '16px',
                'description' => esc_html__( 'Enter line height in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Subtitle Font Weight', 'genesisexpo' ),
                'param_name' => 'subtitle_weight',
                'value' => array(
                    esc_html__( '300 / Light', 'genesisexpo' )      => '300',
                    esc_html__( '400 / Regular', 'genesisexpo' )    => '400',
                    esc_html__( '500 / Medium', 'genesisexpo' )     => '500',
                    esc_html__( '600 / SemiBold', 'genesisexpo' )   => '600',
                    esc_html__( '700 / Bold', 'genesisexpo' )       => '700',
                    esc_html__( '800 / Extra-Bold', 'genesisexpo' ) => '800',
                ),
                'std' => '400',
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Custom subtitle weight', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Subtitle Color', 'genesisexpo' ),
                'param_name' => 'custom_subtitle_color',
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Subtitle Color', 'genesisexpo' ),
                'param_name' => 'subtitle_color',
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
                'value' => $theme_color,
                'save_always' => true,
                'dependency' => array(
                    'element' => 'custom_subtitle_color',
                    'value' => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Choose color for subtitle.', 'genesisexpo' ),
            ), 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for subtitle', 'genesisexpo' ),
                'param_name' => 'custom_fonts_subtitle',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_subtitle',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_subtitle',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Subtitle Styles', 'genesisexpo' ),
            ),     
            // BACKGROUND TITLE STYLES TAB
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Title Styles', 'genesisexpo'),
                'param_name' => 'h_bgtitle_styles',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'BG Title Tag', 'genesisexpo' ),
                'param_name' => 'bgtitle_tag',
                'value' => array(
                    esc_html__( 'div', 'genesisexpo' ) => 'div',
                    esc_html__( 'h2', 'genesisexpo' )  => 'h2',
                    esc_html__( 'h3', 'genesisexpo' )  => 'h3',
                    esc_html__( 'h4', 'genesisexpo' )  => 'h4',
                    esc_html__( 'h5', 'genesisexpo' )  => 'h5',
                    esc_html__( 'h6', 'genesisexpo' )  => 'h6',
                ),
                'std' => 'div',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Your html tag for title', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Background Title Font Size', 'genesisexpo'),
                'param_name' => 'bgtitle_size',
                'value' => '120px',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('BG Title Line Height', 'genesisexpo'),
                'param_name' => 'bgtitle_line_height',
                'value' => '30px',
                'description' => esc_html__( 'Enter line height in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'BG Title Font Weight', 'genesisexpo' ),
                'param_name' => 'bgtitle_weight',
                'value' => array(
                    esc_html__( '300 / Light', 'genesisexpo' )      => '300',
                    esc_html__( '400 / Regular', 'genesisexpo' )    => '400',
                    esc_html__( '500 / Medium', 'genesisexpo' )     => '500',
                    esc_html__( '600 / SemiBold', 'genesisexpo' )   => '600',
                    esc_html__( '700 / Bold', 'genesisexpo' )       => '700',
                    esc_html__( '800 / Extra-Bold', 'genesisexpo' ) => '800',
                ),
                'std' => '800',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'description' => esc_html__( 'Custom BG title weight', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Background Title Color', 'genesisexpo' ),
                'param_name' => 'custom_bgtitle_color',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Background Title Color', 'genesisexpo' ),
                'param_name' => 'bgtitle_color',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'value' => '#f3f3f3',
                'save_always' => true,
                'dependency' => array(
                    'element' => 'custom_bgtitle_color',
                    'value' => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Choose color for bg title.', 'genesisexpo' ),
            ), 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Set Title Resonsive Font Size', 'genesisexpo' ),
                'param_name' => 'bg_responsive_font',
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Small Desktops', 'genesisexpo'),
                'param_name' => 'bg_font_size_desctop',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'bg_responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Tablets', 'genesisexpo'),
                'param_name' => 'bg_font_size_tablet',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'bg_responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Mobile', 'genesisexpo'),
                'param_name' => 'bg_font_size_mobile',
                'description' => esc_html__( 'Enter font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'bg_responsive_font',
                    'value' => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for background title', 'genesisexpo' ),
                'param_name' => 'custom_fonts_bgtitle',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_bgtitle',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_bgtitle',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Background Title Styles', 'genesisexpo' ),
            ),                
        )
    ));
    
    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Double_Headings extends WPBakeryShortCode {
            
        }
    } 
}
