<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Clients', 'genesisexpo'),
        'base' => 'wgl_clients',
        'class' => 'genesisexpo_clients',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_clients',
        'content_element' => true,
        'description' => esc_html__('Display Clients','genesisexpo'),
        'params' => array(
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'genesisexpo' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph - thumbnail, quote, author name and author status.', 'genesisexpo' ),
                'params' => array(
                    array(
                        "type"          => "attach_image",
                        "heading"       => esc_html__( 'Thumbnail', 'genesisexpo' ),
                        "param_name"    => "thumbnail",
                        'edit_field_class' => 'vc_col-sm-6',
                    ),
                    array(
                        "type"          => "attach_image",
                        "heading"       => esc_html__( 'Hover Thumbnail', 'genesisexpo' ),
                        "param_name"    => "hover_thumbnail",
                        'edit_field_class' => 'vc_col-sm-6 no-top-padding',
                        'description' => esc_html__( 'Work only with Exchange Images animation.', 'genesisexpo' ),
                    ),
                    array(
                        'type' => 'wgl_checkbox',
                        'heading' => esc_html__( 'Add Link', 'genesisexpo' ),
                        'param_name' => 'add_link',
                        'edit_field_class' => 'vc_col-sm-12',
                    ),
                    array(
                        'type' => 'vc_link',
                        'heading' => esc_html__( 'Link', 'genesisexpo' ),
                        'param_name' => 'link',
                        'description' => esc_html__('Add link to client image.', 'genesisexpo'),
                        "dependency"    => array(
                            "element"   => "add_link",
                            "value" => 'true'
                        ),
                    ),
                ),
            ),
            array(
                "type"          => "dropdown",
                "heading"       => esc_html__( 'Clients Grid', 'genesisexpo' ),
                "param_name"    => "item_grid",
                "value"         => array(
                    esc_html__( 'One Column', 'genesisexpo' )    => '1',
                    esc_html__( 'Two Columns', 'genesisexpo' )   => '2',
                    esc_html__( 'Three Columns', 'genesisexpo' ) => '3',
                    esc_html__( 'Four Columns', 'genesisexpo' )  => '4',
                    esc_html__( 'Five Columns', 'genesisexpo' )  => '5',
                    esc_html__( 'Six Columns', 'genesisexpo' )  => '6',
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'std' => '4'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Clients Animation for each Image', 'genesisexpo'),
                'param_name' => 'item_anim',
                'value' => array(
                    esc_html__('Shadow', 'genesisexpo') => 'shadow',
                    esc_html__('Zoom', 'genesisexpo') => 'zoom',
                    esc_html__('Opacity', 'genesisexpo') => 'opacity',
                    esc_html__('Grayscale', 'genesisexpo') => 'grayscale',
                    esc_html__('Contrast', 'genesisexpo') => 'contrast',
                    esc_html__('Blur', 'genesisexpo') => 'blur',
                    esc_html__('Invert', 'genesisexpo') => 'invert',
                    esc_html__('Exchange Images', 'genesisexpo') => 'ex_images',
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // carousel heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Add Carousel for Clients Items', 'genesisexpo'),
                'param_name' => 'h_carousel',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                "type"          => "wgl_checkbox",
                'heading' => esc_html__( 'Use Carousel', 'genesisexpo' ),
                "param_name"    => "use_carousel",
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            array(
                "type"          => "wgl_checkbox",
                'heading' => esc_html__( 'Autoplay', 'genesisexpo' ),
                "param_name"    => "autoplay",
                "dependency"    => array(
                    "element"   => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__( 'Autoplay Speed', 'genesisexpo' ),
                "param_name"    => "autoplay_speed",
                "dependency"    => array(
                    "element"   => "autoplay",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                "value"         => "3000",
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Responsive', 'genesisexpo'),
                'param_name' => 'h_resp',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                "dependency"    => array(
                    "element"   => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Customize Responsive', 'genesisexpo' ),
                'param_name' => 'custom_resp',
                "dependency"    => array(
                    "element"   => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),
            // medium desktop
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Medium Desktop', 'genesisexpo'),
                'param_name' => 'h_resp_medium',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_medium',
                'value' => '1025',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_medium_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),

            // tablets
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Tablets', 'genesisexpo'),
                'param_name' => 'h_resp_tablets',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_tablets',
                'value' => '800',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_tablets_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            // mobile phones
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Mobile Phones', 'genesisexpo'),
                'param_name' => 'h_resp_mobile',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_mobile',
                'value' => '480',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_mobile_slides',
                'value' => '',
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Clients extends WPBakeryShortCode {
        }
    }
}
