<?php 


if (!class_exists( 'RWMB_Loader' )) {
	return;
}
class GenesisExpo_Metaboxes{
	public function __construct(){
		//Team Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'team_meta_boxes' ) );

		//Portfolio Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'portfolio_meta_boxes' ) );
		add_filter( 'rwmb_meta_boxes', array( $this, 'portfolio_related_meta_boxes' ) );

		//Blog Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'blog_settings_meta_boxes' ) );
		add_filter( 'rwmb_meta_boxes', array( $this, 'blog_meta_boxes' ) );
		add_filter( 'rwmb_meta_boxes', array( $this, 'blog_related_meta_boxes' ));
		
		//Page Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_layout_meta_boxes' ) );
		//Colors Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_color_meta_boxes' ) );		
		//Logo Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_logo_meta_boxes' ) );		
		//Header Builder Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_header_meta_boxes' ) );
		//Title Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_title_meta_boxes' ) );
		//Footer Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_footer_meta_boxes' ) );				
		//Copyright Fields Metaboxes
		add_filter( 'rwmb_meta_boxes', array( $this, 'page_copyright_meta_boxes' ) );		
	}

	public function team_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Team Options', 'genesisexpo' ),
	        'post_types' => array( 'team' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
		            'name' => esc_html__( 'Info Name Department', 'genesisexpo' ),
		            'id'   => 'department_name',
		            'type' => 'text',
		            'class' => 'name-field'
		        ),       
	        	array(
		            'name' => esc_html__( 'Member Department', 'genesisexpo' ),
		            'id'   => 'department',
		            'type' => 'text',
		            'class' => 'field-inputs'
		        ),
				array(
					'name' => esc_html__( 'Member Info', 'genesisexpo' ),
		            'id'   => 'info_items',
		            'type' => 'social',
		            'clone' => true,
		            'sort_clone'     => true,
		            'options' => array(
						'name'    => array(
							'name' => esc_html__( 'Name', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'description' => array(
							'name' => esc_html__( 'Description', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'link' => array(
							'name' => esc_html__( 'Link', 'genesisexpo' ),
							'type_input' => 'text'
							),
					),
		        ),		
		        array(
					'name'     => esc_html__( 'Social Icons', 'genesisexpo' ),
					'id'          => "soc_icon",
					'type'        => 'select_icon',
					'options'     => WglAdminIcon()->get_icons_name(),
					'clone' => true,
					'sort_clone'     => true,
					'placeholder' => esc_html__( 'Select an icon', 'genesisexpo' ),
					'multiple'    => false,
					'std'         => 'default',
				),
				array(
		            'name' => esc_html__( 'Enter Speeches Info Title', 'genesisexpo' ),
		            'id'   => 'speeches_info_title',
		            'type' => 'text',
		            'class' => 'name-field',
		        ),
				array(
					'name' => esc_html__( 'Member Speeches', 'genesisexpo' ),
		            'id'   => 'speeches_info',
		            'type' => 'social',
		            'clone' => true,
		            'sort_clone'     => true,
		            'options' => array(
						'day'    => array(
							'name' => esc_html__( 'Day', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'time' => array(
							'name' => esc_html__( 'Time', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'description' => array(
							'name' => esc_html__( 'Description', 'genesisexpo' ),
							'type_input' => 'text'
							),
					),
		        ), 	
				array(
					'id'   => 'mb_download_link',
					'name' => esc_html__( 'Add Download VCard Link', 'genesisexpo' ),
					'type' => 'switch',
				),
				array(
		            'name' => esc_html__( 'Enter Text Link', 'genesisexpo' ),
		            'id'   => 'mb_vcard_text',
		            'type' => 'text',
		            'class' => 'name-field',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_download_link','=','1')
							),
						),
					),
					'std' => 'Download VCard',
		        ),  
				array(
		            'name' => esc_html__( 'Enter Link for Download VCard', 'genesisexpo' ),
		            'id'   => 'mb_vcard_link',
		            'type' => 'text',
		            'class' => 'name-field',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_download_link','=','1')
							),
						),
					),
		        ),
		        array(
					'name'             => esc_html__( 'Info Background Image', 'genesisexpo' ),
					'id'               => "mb_info_bg",
					'type'             => 'file_advanced',
					'max_file_uploads' => 1,
					'mime_type'        => 'image',
				), 
	        ),
	    );
	    return $meta_boxes;
	}
	
	public function portfolio_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Portfolio Options', 'genesisexpo' ),
	        'post_types' => array( 'portfolio' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'id'   => 'mb_portfolio_featured_img',
					'name' => esc_html__( 'Show Featured image on single', 'genesisexpo' ),
					'type' => 'switch',
					'std' => 'true',
				),        	
				array(
					'id'   => 'mb_portfolio_title',
					'name' => esc_html__( 'Show Title on single', 'genesisexpo' ),
					'type' => 'switch',
				),	
				array(
					'name' => esc_html__( 'Info', 'genesisexpo' ),
		            'id'   => 'mb_portfolio_info_items',
		            'type' => 'social',
		            'clone' => true,
		            'sort_clone'     => true,
		            'desc' => esc_html__( 'Description', 'genesisexpo' ),
		            'options' => array(
						'name'    => array(
							'name' => esc_html__( 'Name', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'description' => array(
							'name' => esc_html__( 'Description', 'genesisexpo' ),
							'type_input' => 'text'
							),
						'link' => array(
							'name' => esc_html__( 'Url', 'genesisexpo' ),
							'type_input' => 'text'
							),
					),
		        ),		
		        array(
					'name'     => esc_html__( 'Info Description', 'genesisexpo' ),
					'id'          => "mb_portfolio_editor",
					'type'        => 'wysiwyg',
					'multiple'    => false,
					'desc' => esc_html__( 'Info description is shown in one row with a main info', 'genesisexpo' ),
				),			
		        array(
					'name'     => esc_html__( 'Tags On/Off', 'genesisexpo' ),
					'id'          => "mb_portfolio_above_content_cats",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'yes' => esc_html__( 'On', 'genesisexpo' ),
						'no' => esc_html__( 'Off', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),		
		        array(
					'name'     => esc_html__( 'Share Links On/Off', 'genesisexpo' ),
					'id'          => "mb_portfolio_above_content_share",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'yes' => esc_html__( 'On', 'genesisexpo' ),
						'no' => esc_html__( 'Off', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),	
	        ),
	    );
	    return $meta_boxes;
	}

	public function portfolio_related_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Related Portfolio', 'genesisexpo' ),
	        'post_types' => array( 'portfolio' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'id'   => 'mb_pf_carousel_r',
					'name' => esc_html__( 'Display items carousel for this portfolio post', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
				),           	
				array(
					'id'   => 'mb_pf_show_r',
					'name' => esc_html__( 'Show related', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
				),
				array(
					'name' => esc_html__( 'Title', 'genesisexpo' ),
					'id'   => "mb_pf_title_r",
					'type' => 'text',
					'std'  => 'Related Portfolio',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_pf_show_r','=','1')
							),
						),
					),
				), 			
				array(
					'name' => esc_html__( 'Categories', 'genesisexpo' ),
					'id'   => "mb_pf_cat_r",
					'multiple'    => true,
					'type' => 'taxonomy_advanced',
					'taxonomy' => 'portfolio-category',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_pf_show_r','=','1')
							),
						),
					),
				),     
				array(
					'name'     => esc_html__( 'Columns', 'genesisexpo' ),
					'id'          => "mb_pf_column_r",
					'type'        => 'button_group',
					'options'     => array(
						'def' => esc_html__( 'Default', 'genesisexpo' ),
						'1' => esc_html__( '1', 'genesisexpo' ),
						'2' => esc_html__( '2', 'genesisexpo' ),
						'3' => esc_html__( '3', 'genesisexpo' ),
						'4' => esc_html__( '4', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'def',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_pf_show_r','=','1')
							),
						),
					),
				),  
				array(
					'name' => esc_html__( 'Number of Related Items', 'genesisexpo' ),
					'id'   => "mb_pf_number_r",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'std'  => 4,
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_pf_show_r','=','1')
							),
						),
					),
				),
	        ),
	    );
	    return $meta_boxes;
	}

	public function blog_settings_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Post Settings', 'genesisexpo' ),
	        'post_types' => array( 'post' ),
	        'context' => 'advanced',
	        'fields'     => array(
				array(
					'name'     => esc_html__( 'Post Layout', 'genesisexpo' ),
					'id'          => "mb_post_layout_conditional",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'custom' => esc_html__( 'Custom', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),        
				array(
					'name'     => esc_html__( 'Post Layout Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_post_layout_conditional','=','custom')
						)),
					),
				),  	    
				array(
					'name'     => esc_html__( 'Post Layout', 'genesisexpo' ),
					'id'          => "mb_single_type_layout",
					'type'        => 'button_group',
					'options'     => array(
						'1' => esc_html__( 'Title First', 'genesisexpo' ),
						'2' => esc_html__( 'Image First', 'genesisexpo' ),
						'3' => esc_html__( 'Overlay Image', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => '1',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_post_layout_conditional','=','custom')
							),
						),
					),
				), 
				array(
					'name' => esc_html__( 'Spacing', 'genesisexpo' ),
					'id'   => 'mb_single_padding_layout_3',
					'type' => 'wgl_offset',
					'options' => array(
						'mode'   => 'padding',
						'top'    => true,
						'right'  => false,
						'bottom' => true,
						'left'   => false,
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_post_layout_conditional','=','custom'),
							array('mb_single_type_layout','=','3'),
						)),
					),
					'std' => array(
						'padding-top' => '337',
						'padding-bottom' => '41'
					)
				),
				array(
					'id'   => 'mb_single_apply_animation',
					'name' => esc_html__( 'Apply Animation', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_post_layout_conditional','=','custom'),
							array('mb_single_type_layout','=','3'),
						)),
					),
				),
	        ),
	    );
	    return $meta_boxes;
	}

	public function blog_meta_boxes( $meta_boxes ) {
		$meta_boxes[] = array(
			'title'      => esc_html__( 'Post Format Layout', 'genesisexpo' ),
			'post_types' => array( 'post' ),
			'context' => 'advanced',
			'fields'     => array(
				// Standard Post Format
				array(
					'name'             => esc_html__( 'Standard Post( Enabled only Featured Image for this post format)', 'genesisexpo' ),
					'id'               => "post_format_standard",
					'type'             => 'static-text',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','0')
							),
						),
					),
				),
				// Gallery Post Format  
				array(
					'name'     => esc_html__( 'Gallery Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('formatdiv','=','gallery')
						)),
					),
				),  
				array(
					'name'             => esc_html__( 'Add Images', 'genesisexpo' ),
					'id'               => "post_format_gallery",
					'type'             => 'image_advanced',
					'max_file_uploads' => '',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','gallery')
							),
						),
					),
				),
				// Video Post Format
				array(
					'name'     => esc_html__( 'Video Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('formatdiv','=','video')
						)),
					),
				), 
				array(
					'name' => esc_html__( 'Video Style', 'genesisexpo' ),
					'id'   => "post_format_video_style",
					'type'        => 'select',
					'options'     => array(
						'bg_video' => esc_html__( 'Background Video', 'genesisexpo' ),
						'popup' => esc_html__( 'Popup', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'bg_video',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','video')
							),
						),
					),
				),	
				array(
					'name' => esc_html__( 'Start Video', 'genesisexpo' ),
					'id'   => "start_video",
					'type' => 'number',
					'std'  => '0',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','video'),
								array('post_format_video_style','=','bg_video'),
							),
						),
					),
				),				
				array(
					'name' => esc_html__( 'End Video', 'genesisexpo' ),
					'id'   => "end_video",
					'type' => 'number',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','video'),
								array('post_format_video_style','=','bg_video'),
							),
						),
					),
				),	
				array(
					'name' => esc_html__( 'oEmbed URL', 'genesisexpo' ),
					'id'   => "post_format_video_url",
					'type' => 'oembed',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','video')
							),
							array(
								array('post_format_video_select','=','oEmbed')
							)
						),
					),
				),
				// Quote Post Format
				array(
					'name'     => esc_html__( 'Quote Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('formatdiv','=','quote')
						)),
					),
				), 
				array(
					'name'             => esc_html__( 'Quote Text', 'genesisexpo' ),
					'id'               => "post_format_qoute_text",
					'type'             => 'textarea',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','quote')
							),
						),
					),
				),
				array(
					'name'             => esc_html__( 'Author Name', 'genesisexpo' ),
					'id'               => "post_format_qoute_name",
					'type'             => 'text',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','quote')
							),
						),
					),
				),			
				array(
					'name'             => esc_html__( 'Author Position', 'genesisexpo' ),
					'id'               => "post_format_qoute_position",
					'type'             => 'text',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','quote')
							),
						),
					),
				),
				array(
					'name'             => esc_html__( 'Author Avatar', 'genesisexpo' ),
					'id'               => "post_format_qoute_avatar",
					'type'             => 'image_advanced',
					'max_file_uploads' => 1,
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','quote')
							),
						),
					),
				),
				// Audio Post Format
				array(
					'name'     => esc_html__( 'Audio Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('formatdiv','=','audio')
						)),
					),
				), 
				array(
					'name' => esc_html__( 'oEmbed URL', 'genesisexpo' ),
					'id'   => "post_format_audio_url",
					'type' => 'oembed',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','audio')
							),
							array(
								array('post_format_audio_select','=','oEmbed')
							)
						),
					),
				),
				// Link Post Format
				array(
					'name'     => esc_html__( 'Link Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('formatdiv','=','link')
						)),
					),
				), 
				array(
					'name'             => esc_html__( 'URL', 'genesisexpo' ),
					'id'               => "post_format_link_url",
					'type'             => 'url',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','link')
							),
						),
					),
				),
				array(
					'name'             => esc_html__( 'Text', 'genesisexpo' ),
					'id'               => "post_format_link_text",
					'type'             => 'text',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('formatdiv','=','link')
							),
						),
					),
				),
			)
		);
		return $meta_boxes;
	}

	public function blog_related_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Related Blog Post', 'genesisexpo' ),
	        'post_types' => array( 'post' ),
	        'context' => 'advanced',
	        'fields'     => array(        	
				array(
					'id'   => 'mb_blog_show_r',
					'name' => esc_html__( 'Related On/Off', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
				),
				array(
					'name'     => esc_html__( 'Related Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_blog_show_r','=','1')
						)),
					),
				), 
				array(
					'name' => esc_html__( 'Title', 'genesisexpo' ),
					'id'   => "mb_blog_title_r",
					'type' => 'text',
					'std'  => 'Related Posts',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_blog_show_r','=','1')
							),
						),
					),
				), 			
				array(
					'name' => esc_html__( 'Categories', 'genesisexpo' ),
					'id'   => "mb_blog_cat_r",
					'multiple'    => true,
					'type' => 'taxonomy_advanced',
					'taxonomy' => 'category',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_blog_show_r','=','1')
							),
						),
					),
				),     
				array(
					'name'     => esc_html__( 'Columns', 'genesisexpo' ),
					'id'          => "mb_blog_column_r",
					'type'        => 'button_group',
					'options'     => array(
						'12' => esc_html__( '1', 'genesisexpo' ),
						'6' => esc_html__( '2', 'genesisexpo' ),
						'4' => esc_html__( '3', 'genesisexpo' ),
						'3' => esc_html__( '4', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => '6',
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_blog_show_r','=','1')
							),
						),
					),
				),  
				array(
					'name' => esc_html__( 'Number of Related Items', 'genesisexpo' ),
					'id'   => "mb_blog_number_r",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'std'  => 2,
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_blog_show_r','=','1')
							),
						),
					),
				),
	        	array(
					'id'   => 'mb_blog_carousel_r',
					'name' => esc_html__( 'Display items carousel for this blog post', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
					'attributes' => array(
						'data-conditional-logic' => array(
							array(
								array('mb_blog_show_r','=','1')
							),
						),
					),
				),  
	        ),
	    );
	    return $meta_boxes;
	}

	public function page_layout_meta_boxes( $meta_boxes ) {

	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Page Layout', 'genesisexpo' ),
	        'post_types' => array( 'page' , 'post', 'team', 'practice','portfolio' ),
	        'context' => 'advanced',
	        'fields'     => array(
				array(
					'name'     => esc_html__( 'Page Sidebar Layout', 'genesisexpo' ),
					'id'          => "mb_page_sidebar_layout",
					'type'        => 'wgl_image_select',
					'options'     => array(
						'default' => get_template_directory_uri() . '/core/admin/img/options/1c.png',
						'none'    => get_template_directory_uri() . '/core/admin/img/options/none.png',
						'left'    => get_template_directory_uri() . '/core/admin/img/options/2cl.png',
						'right'   => get_template_directory_uri() . '/core/admin/img/options/2cr.png',
					),
					'std'         => 'default',
				),
				array(
					'name'     => esc_html__( 'Sidebar Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_sidebar_layout','!=','default'),
							array('mb_page_sidebar_layout','!=','none'),
						)),
					),
				),
				array(
					'name'     => esc_html__( 'Page Sidebar', 'genesisexpo' ),
					'id'          => "mb_page_sidebar_def",
					'type'        => 'select',
					'placeholder' => 'Select a Sidebar',
					'options'     => genesisexpo_get_all_sidebar(),
					'multiple'    => false,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_sidebar_layout','!=','default'),
							array('mb_page_sidebar_layout','!=','none'),
						)),
					),
				),			
				array(
					'name'     => esc_html__( 'Page Sidebar Width', 'genesisexpo' ),
					'id'          => "mb_page_sidebar_def_width",
					'type'        => 'button_group',
					'options'     => array(	
						'9' => esc_html( '25%' ),
						'8' => esc_html( '33%' ),
					),
					'std'  => '9',
					'multiple'    => false,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_sidebar_layout','!=','default'),
							array('mb_page_sidebar_layout','!=','none'),
						)),
					),
				),
				array(
					'id'   => 'mb_sticky_sidebar',
					'name' => esc_html__( 'Sticky Sidebar On?', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_sidebar_layout','!=','default'),
							array('mb_page_sidebar_layout','!=','none'),
						)),
					),
				),
				array(
					'name'     => esc_html__( 'Sidebar Side Gap', 'genesisexpo' ),
					'id'          => "mb_sidebar_gap",
					'type'        => 'select',
					'options'     => array(	
						'def' => 'Default',
	                    '0' => '0',     
	                    '15' => '15',     
	                    '20' => '20',     
	                    '25' => '25',     
	                    '30' => '30',     
	                    '35' => '35',     
	                    '40' => '40',     
	                    '45' => '45',     
	                    '50' => '50', 
					),
					'std'         => 'def',
					'multiple'    => false,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_sidebar_layout','!=','default'),
							array('mb_page_sidebar_layout','!=','none'),
						)),
					),
				),
	        )
	    );
	    return $meta_boxes;
	}

	public function page_color_meta_boxes( $meta_boxes ) {

	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Page Colors', 'genesisexpo' ),
	        'post_types' => array( 'page' , 'post', 'team', 'practice','portfolio' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'name'     => esc_html__( 'Page Colors', 'genesisexpo' ),
					'id'          => "mb_page_colors_switch",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'custom' => esc_html__( 'Custom', 'genesisexpo' ),
					),
					'inline'   		=> true,
					'multiple'    => false,
					'std'         => 'default',
				),
				array(
					'name'     => esc_html__( 'Colors Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom')
						)),
					),
				),
				array(
					'name'     	=> esc_html__( 'General Theme Color', 'genesisexpo' ),
	                'id'        => 'mb_page_theme_color',
	                'type'      => 'color',
	                'std'         => '#fd226a',
					'js_options' => array(
						'defaultColor' => '#fd226a',
					),
	                'validate'  => 'color',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom'),
						)),
					),
	            ),				
	            array(
					'name'     	=> esc_html__( 'Secondary Theme Color', 'genesisexpo' ),
	                'id'        => 'mb_page_theme_secondary_color',
	                'type'      => 'color',
	                'std'         => '#7c529c',
					'js_options' => array(
						'defaultColor' => '#7c529c',
					),
	                'validate'  => 'color',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom'),
						)),
					),
	            ),
				array(
					'name'     	=> esc_html__( 'Body Background Color', 'genesisexpo' ),
	                'id'        => 'mb_body_background_color',
	                'type'      => 'color',
	                'std'         => '#ffffff',
					'js_options' => array(
						'defaultColor' => '#ffffff',
					),
	                'validate'  => 'color',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom'),
						)),
					),
	            ),
				array(
					'name'     => esc_html__( 'Scroll Up Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom')
						)),
					),
				),
				array(
					'name'     	=> esc_html__( 'Button Background Color', 'genesisexpo' ),
	                'id'        => 'mb_scroll_up_bg_color',
	                'type'      => 'color',
	                'std'         => '#fd226a',
					'js_options' => array(
						'defaultColor' => '#fd226a',
					),
	                'validate'  => 'color',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom'),
						)),
					),
	            ),				
	            array(
					'name'     	=> esc_html__( 'Button Arrow Color', 'genesisexpo' ),
	                'id'        => 'mb_scroll_up_arrow_color',
	                'type'      => 'color',
	                'std'         => '#ffffff',
					'js_options' => array(
						'defaultColor' => '#ffffff',
					),
	                'validate'  => 'color',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_colors_switch','=','custom'),
						)),
					),
	            ),
	        )
	    );
	    return $meta_boxes;
	}

	public function page_logo_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Logo', 'genesisexpo' ),
	        'post_types' => array( 'page' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'name'     => esc_html__( 'Logo', 'genesisexpo' ),
					'id'          => "mb_customize_logo",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'custom' => esc_html__( 'Custom', 'genesisexpo' ),
					),
					'multiple'    => false,
					'inline'    => true,
					'std'         => 'default',
				),
				array(
					'name'     => esc_html__( 'Logo Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'name'             => esc_html__( 'Header Logo', 'genesisexpo' ),
					'id'               => "mb_header_logo",
					'type'             => 'image_advanced',
					'max_file_uploads' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'id'   => 'mb_logo_height_custom',
					'name' => esc_html__( 'Enable Logo Height', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
					    	array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Set Logo Height', 'genesisexpo' ),
					'id'   => "mb_logo_height",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'std'  => 50,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom'),
							array('mb_logo_height_custom','=',true)
						)),
					),
				),
				array(
					'name'             => esc_html__( 'Sticky Logo', 'genesisexpo' ),
					'id'               => "mb_logo_sticky",
					'type'             => 'image_advanced',
					'max_file_uploads' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'id'   => 'mb_sticky_logo_height_custom',
					'name' => esc_html__( 'Enable Sticky Logo Height', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
					    	array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Set Sticky Logo Height', 'genesisexpo' ),
					'id'   => "mb_sticky_logo_height",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom'),
							array('mb_sticky_logo_height_custom','=',true),
						)),
					),
				),
				array(
					'name'             => esc_html__( 'Mobile Logo', 'genesisexpo' ),
					'id'               => "mb_logo_mobile",
					'type'             => 'image_advanced',
					'max_file_uploads' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'id'   => 'mb_mobile_logo_height_custom',
					'name' => esc_html__( 'Enable Mobile Logo Height', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
					    	array('mb_customize_logo','=','custom')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Set Mobile Logo Height', 'genesisexpo' ),
					'id'   => "mb_mobile_logo_height",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_logo','=','custom'),
							array('mb_mobile_logo_height_custom','=',true),
						)),
					),
				),
	        )
	    );
	    return $meta_boxes;
	}

	public function page_header_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Header', 'genesisexpo' ),
	        'post_types' => array( 'page' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'name'     => esc_html__( 'Header Settings', 'genesisexpo' ),
					'id'          => "mb_customize_header_layout",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'default', 'genesisexpo' ),
						'custom' => esc_html__( 'custom', 'genesisexpo' ),
						'hide' => esc_html__( 'hide', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),
	        	array(
					'name'     => esc_html__( 'Header Builder', 'genesisexpo' ),
					'id'          => "mb_customize_header",
					'type'        => 'select',
					'options'     => genesisexpo_get_custom_preset(),
					'multiple'    => false,
					'std'         => 'default',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_header_layout','!=','hide')
						)),
					),
				),			
				// It is works 
				array(
					'id'   => 'mb_menu_header',
					'name' => esc_html__( 'Menu ', 'genesisexpo' ),
					'type' => 'select',
					'options'     => genesisexpo_get_custom_menu(),
					'multiple'    => false,
					'std'         => 'default',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_header_layout','=','custom')
						)),
					),
				),
				array(
					'id'   => 'mb_header_sticky',
					'name' => esc_html__( 'Sticky Header', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_customize_header_layout','=','custom')
						)),
					),
				),
	        )
	    );
	    return $meta_boxes;
	}

	public function page_title_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Page Title', 'genesisexpo' ),
	        'post_types' => array( 'page', 'post', 'team', 'practice','portfolio' ),
	        'context' => 'advanced',
	        'fields'     => array(
				array(
					'id'       => 'mb_page_title_switch',
					'name'     => esc_html__( 'Page Title', 'genesisexpo' ),
					'type'     => 'button_group',
					'options'  => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'on' => esc_html__( 'On', 'genesisexpo' ),
						'off' => esc_html__( 'Off', 'genesisexpo' ),
					),
					'inline'   => true,
					'multiple' => false,
					'std'      => 'default'
				),
				array(
					'name'     => esc_html__( 'Page Title Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name'             => esc_html__( 'Background', 'genesisexpo' ),
					'id'               => "mb_page_title_bg",
					'type'             => 'wgl_background',	
					'color'      	   => '#1e73be',
				    'image'     	   => '',
				    'position'   	   => 'center center',
				    'attachment' 	   => 'scroll',
				    'size'       	   => 'cover',
				    'repeat'     	   => 'no-repeat',			
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),			
				array( 
					'name' => esc_html__( 'Height', 'genesisexpo' ),
					'id'   => 'mb_page_title_height',
					'type' => 'number',
					'std'  => 345,
					'min'  => 0,
					'step' => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name'     => esc_html__( 'Text Align', 'genesisexpo' ),
					'id'       => 'mb_page_title_align',
					'type'     => 'button_group',
					'options'  => array(
						'left' => esc_html__( 'left', 'genesisexpo' ),
						'center' => esc_html__( 'center', 'genesisexpo' ),
						'right' => esc_html__( 'right', 'genesisexpo' ),
					),
					'multiple' => false,
					'std'         => 'left',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Padding Top/Bottom', 'genesisexpo' ),
					'id'   => 'mb_page_title_padding',
					'type' => 'wgl_offset',
					'options' => array(
						'mode'   => 'padding',
						'top'    => true,
						'right'  => false,
						'bottom' => true,
						'left'   => false,
					),
					'std' => array(
						'padding-top'    => '90',
						'padding-bottom' => '0',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Margin Bottom', 'genesisexpo' ),
					'id'   => "mb_page_title_margin",
					'type' => 'wgl_offset',
					'options' => array(
						'mode'   => 'margin',
						'top'    => false,
						'right'  => false,
						'bottom' => true,
						'left'   => false,
					),
					'std' => array(
						'margin-bottom' => '60',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'id'   => 'mb_page_title_parallax',
					'name' => esc_html__( 'Add Page Title Parallax', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Prallax Speed', 'genesisexpo' ),
					'id'   => "mb_page_title_parallax_speed",
					'type' => 'number',
					'std'  => 0.3,
					'step' => 0.1,
					'attributes' => array(
						'data-conditional-logic'  =>  array( array(
							array('mb_page_title_parallax','=',true),
							array('mb_page_title_switch','=','on'),
						)),
					),
				),
				array(
					'id'   => 'mb_page_change_tile_switch',
					'name' => esc_html__( 'Custom Page Title', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),		
				array(
		            'name' => esc_html__( 'Page Title', 'genesisexpo' ),
		            'id'   => 'mb_page_change_tile',
		            'type' => 'text',
		            'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
					    	array('mb_page_change_tile_switch','=',1),
							array('mb_page_title_switch','=','on'),
						)),
					),
		        ),		
				array(
					'id'   => 'mb_page_title_breadcrumbs_switch',
					'name' => esc_html__( 'Show Breadcrumbs', 'genesisexpo' ),
					'type' => 'switch',
					'std'  => 1,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name'     => esc_html__( 'Page Title Typography', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Page Title Font', 'genesisexpo' ),
					'id'   => 'mb_page_title_font',
					'type' => 'wgl_font',
					'options' => array(
						'font-size' => true,
						'line-height' => true,
						'font-weight' => false,
						'color' => true,
					),
					'std' => array(
						'font-size' => '120',
						'line-height' => '110',
						'color' => '#ffffff',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Page Title Breadcrumbs Font', 'genesisexpo' ),
					'id'   => 'mb_page_title_breadcrumbs_font',
					'type' => 'wgl_font',
					'options' => array(
						'font-size' => true,
						'line-height' => true,
						'font-weight' => false,
						'color' => true,
					),
					'std' => array(
						'font-size' => '20',
						'line-height' => '24',
						'color' => '#fd226a',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_page_title_switch','=','on')
						)),
					),
				),
	        ),
	    );
	    return $meta_boxes;
	}

	public function page_footer_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Footer', 'genesisexpo' ),
	        'post_types' => array( 'page' ),
	        'context' => 'advanced',
	        'fields'     => array(
	        	array(
					'name'     => esc_html__( 'Footer', 'genesisexpo' ),
					'id'          => "mb_footer_switch",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'on' => esc_html__( 'On', 'genesisexpo' ),
						'off' => esc_html__( 'Off', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),
				array(
					'name'     => esc_html__( 'Footer Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on')
						)),
					),
				), 
				array(
					'id'   => 'mb_footer_add_wave',
					'name' => esc_html__( 'Add Wave', 'genesisexpo' ),
					'type' => 'switch',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Set Wave Height', 'genesisexpo' ),
					'id'   => "mb_footer_wave_height",
					'type' => 'number',
					'min'  => 0,
					'step' => 1,
					'std'  => 158,
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
					    	array('mb_footer_switch','=','on'),
							array('mb_footer_add_wave','=','1')
						)),
					),
				),
				array(
					'name'     => esc_html__( 'Content Type', 'genesisexpo' ),
					'id'          => 'mb_footer_content_type',
					'type'        => 'button_group',
					'options'     => array(
						'widgets' => esc_html__( 'Default', 'genesisexpo' ),
						'pages' => esc_html__( 'Page', 'genesisexpo' )		
					),
					'multiple'    => false,
					'std'         => 'widgets',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on')
						)),
					),
				),
				array(
	        		'name'        => 'Select a page',
					'id'          => 'mb_footer_page_select',
					'type'        => 'post',
					'post_type'   => 'footer',
					'field_type'  => 'select_advanced',
					'placeholder' => 'Select a page',
					'query_args'  => array(
					    'post_status'    => 'publish',
					    'posts_per_page' => - 1,
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on'),
							array('mb_footer_content_type','=','pages')
						)),
					),
	        	),
				array(
					'name' => esc_html__( 'Paddings', 'genesisexpo' ),
					'id'   => 'mb_footer_spacing',
					'type' => 'wgl_offset',
					'options' => array(
						'mode'   => 'padding',
						'top'    => true,
						'right'  => true,
						'bottom' => true,
						'left'   => true,
					),
					'std' => array(
						'padding-top'    => '98',
						'padding-right'  => '0',
						'padding-bottom' => '10',
						'padding-left'   => '0'
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on')
						)),
					),
				),	
				array(
					'name'             => esc_html__( 'Background', 'genesisexpo' ),
					'id'               => "mb_footer_bg",
					'type'             => 'wgl_background',	
					'color'      	   => '#14081f',
				    'image'     	   => '',
				    'position'   	   => 'center center',
				    'attachment' 	   => 'scroll',
				    'size'       	   => 'cover',
				    'repeat'     	   => 'no-repeat',			
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_footer_switch','=','on')
						)),
					),
				),				
	        ),
	     );
	    return $meta_boxes;
	}	

	public function page_copyright_meta_boxes( $meta_boxes ) {
	    $meta_boxes[] = array(
	        'title'      => esc_html__( 'Copyright', 'genesisexpo' ),
	        'post_types' => array( 'page' ),
	        'context' => 'advanced',
	        'fields'     => array(
				array(
					'name'     => esc_html__( 'Copyright', 'genesisexpo' ),
					'id'          => "mb_copyright_switch",
					'type'        => 'button_group',
					'options'     => array(
						'default' => esc_html__( 'Default', 'genesisexpo' ),
						'on' => esc_html__( 'On', 'genesisexpo' ),
						'off' => esc_html__( 'Off', 'genesisexpo' ),
					),
					'multiple'    => false,
					'std'         => 'default',
				),
				array(
					'name'     => esc_html__( 'Copyright Settings', 'genesisexpo' ),
					'type'     => 'wgl_heading',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_copyright_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Editor', 'genesisexpo' ),
					'id'   => "mb_copyright_editor",
					'type' => 'textarea',
					'cols' => 20,
					'rows' => 3,
					'std'  => 'Copyright © 2018 GenesisExpo by WebGeniusLab. All Rights Reserved',
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(						
							array('mb_copyright_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Background Color', 'genesisexpo' ),
					'id'   => "mb_copyright_bg_color",
					'type' => 'color',
					'std'  => '#1d1f21',
					'js_options' => array(
						'defaultColor' => '#1d1f21',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(						
							array('mb_copyright_switch','=','on')
						)),
					),
				),
				array(
					'name' => esc_html__( 'Paddings', 'genesisexpo' ),
					'id'   => 'mb_copyright_spacing',
					'type' => 'wgl_offset',
					'options' => array(
						'mode'   => 'padding',
						'top'    => true,
						'right'  => false,
						'bottom' => true,
						'left'   => false,
					),
					'std' => array(
						'padding-top'    => '20',
						'padding-bottom' => '20',
					),
					'attributes' => array(
					    'data-conditional-logic'  =>  array( array(
							array('mb_copyright_switch','=','on')
						)),
					),
				),
	        ),
	     );
	    return $meta_boxes;

	}

}
new GenesisExpo_Metaboxes();

?>