<?php

/**
 * Template Welcome
 *
 * @link       https://themeforest.net/user/webgeniuslab
 * @since      1.0.0
 *
 * @package    GenesisExpo
 * @subpackage GenesisExpo/core/dashboard
 */

/**
 * @since      1.0.0
 * @package    GenesisExpo
 * @subpackage GenesisExpo/core/dashboard
 * @author     WebGeniusLab <webgeniuslab@gmail.com>
 */

$theme = wp_get_theme();
$allowed_html = array(
	'a' => array(
		'href' => true,
		'target' => true,
	),
);
?>
<div class="wgl-welcome_page">
	<div class="wgl-welcome_title">
		<h1><?php esc_html_e('Welcome to', 'genesisexpo');?>
			<?php echo esc_html(wp_get_theme()->get('Name')); ?> 
		</h1>		
	</div>
	<div class="wgl-version_theme">
		<?php esc_html_e('Version - ', 'genesisexpo');?>
		<?php echo esc_html(wp_get_theme()->get('Version')); ?>	
	</div>	
	<div class="wgl-welcome_subtitle">
			<?php
				echo sprintf(esc_html__('%s is already installed and ready to use! Let\'s build something impressive.', 'genesisexpo'), esc_html(wp_get_theme()->get('Name'))) ;
			?>
	</div>
	
	<div class="wgl-welcome-step_wrap">
		<div class="wgl-welcome_sidebar left_sidebar">
			<div class="theme-screenshot">
				<img src="<?php echo esc_url(get_template_directory_uri() . "/screenshot.png"); ?>">

			</div>
		</div>
		<div class="wgl-welcome_content">
			<div class="step-subtitle">
				<?php
					echo sprintf(esc_html__('Just complete the steps below and you will be able to use all functionalities of %s theme by WebGeniusLab:', 'genesisexpo'), esc_html(wp_get_theme()->get('Name')));
				?>
			</div>
			<ul>
			  <li>
			  	<span class="step">
			  		<?php esc_html_e('Step 1', 'genesisexpo');?>		
			  	</span>
			  	<?php esc_html_e('Activate your license.', 'genesisexpo');?>
			  	<span class="attention-title">
			  		<strong>
			  			<?php esc_html_e('Important:', 'genesisexpo');?>
			  		</strong>
			  		<?php esc_html_e('one license  only for one website', 'genesisexpo');?>
			  	</span>
			  </li>			  
			  <li>
			  	<span class="step">
			  		<?php esc_html_e('Step 2', 'genesisexpo');?>		
			  	</span>
			  	<?php 
				echo sprintf( wp_kses( __( 'Check <a target="_blank" href="%s">requirements</a> to avoid errors with your WordPress.', 'genesisexpo' ), $allowed_html), esc_url( admin_url( 'admin.php?page=wgl-status-panel' ) ) );

			  	?>
			  </li>
			  <li>
			  	<span class="step">
			  		<?php esc_html_e('Step 3', 'genesisexpo');?>
			  	</span>
			  	<?php esc_html_e('Install Required and recommended plugins.', 'genesisexpo');?>
			  </li>
			  <li>
			  	<span class="step">
			  		<?php esc_html_e('Step 4', 'genesisexpo');?>
			  	</span>
			  	<?php esc_html_e('Import demo content', 'genesisexpo');?> 
			  </li>
			</ul>	
		</div>
	
	</div>


</div>
