<?php
	$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
	$header_font = GenesisExpo_Theme_Helper::get_option('header-font');

	$defaults = array(
		// General
		'title' => '',
		'subtitle' => '',
		'bgtitle' => '',
		'align' => 'left',
		'extra_class' => '',
		// Title
		'title_tag' => 'div',
		'title_size' => '40px',
		'title_line_height' => '52px',
		'title_weight' => '500',
		'custom_title_color' => false,
		'title_color' => esc_attr($header_font['color']),
		'responsive_font' => false,
		'font_size_desctop' => '',
		'font_size_tablet' => '',
		'font_size_mobile' => '',
		'custom_fonts_title' => false,
		// Subtitle
		'subtitle_tag' => 'div',
		'subtitle_size' => '22px',
		'subtitle_line_height' => '16px',
		'subtitle_weight' => '400',
		'custom_subtitle_color' => false,
		'subtitle_color' => $theme_color,
		'custom_fonts_subtitle' => false,
		// Bg title
		'bgtitle_tag' => 'div',
		'bgtitle_size' => '120px',
		'bgtitle_line_height' => '30px',
		'bgtitle_weight' => '800',
		'custom_bgtitle_color' => false,
		'bgtitle_color' => '#f3f3f3',
		'bg_responsive_font' => false,
		'bg_font_size_desctop' => '',
		'bg_font_size_tablet' => '',
		'bg_font_size_mobile' => '',
		'custom_fonts_bgtitle' => false,

	);
	$atts = vc_shortcode_attribute_parse($defaults, $atts);
	extract($atts);

	$output = $title_render = $bgtitle_render = $subtitle_render = $dbl_head_wrap_classes = $animation_class = '';

	$dbl_id = uniqid( "genesisexpo_dbl_" );
	$dbl_attr = 'id='.$dbl_id;

	// Render Google Fonts
	extract( GenesisExpo_GoogleFontsRender::getAttributes( $atts, $this, array('google_fonts_title','google_fonts_subtitle','google_fonts_bgtitle') ) );
	$title_font_style = !empty($styles_google_fonts_title) ? esc_attr( $styles_google_fonts_title ) : '';
	$subtitle_font_style = !empty($styles_google_fonts_subtitle) ? esc_attr( $styles_google_fonts_subtitle ) : '';
	$bgtitle_font_style = !empty($styles_google_fonts_bgtitle) ? esc_attr( $styles_google_fonts_bgtitle ) : '';

	// title styles
	$title_size_style = !empty($title_size) ? 'font-size:' . (int)$title_size . 'px; ' : '';
	$title_line_height_responsive = !empty($title_line_height) ? round(((int)$title_line_height / (int)$title_size), 3) : '';
	$title_line_height_style = !empty($title_line_height_responsive) ? 'line-height:' . $title_line_height_responsive .'; ' : '';
	$title_weight_style = !empty($title_weight) ? 'font-weight:' . (int)$title_weight . '; ' : '';
	$title_color_style = !empty($title_color && (bool)$custom_title_color) ? 'color:' . esc_attr($title_color) . '; ' : '';

	// Font Size of Title
	if (!empty($title_size_style) || !empty($title_line_height_style) || !empty($title_weight_style) || !empty($title_color_style) || !empty($title_font_style)) {
		$title_styles = 'style="'.$title_size_style.$title_line_height_style.$title_weight_style.$title_color_style.$title_font_style.'"';
	}

	// Subtitle styles
	$subtitle_size_style = !empty($subtitle_size) ? 'font-size:' . (int)$subtitle_size . 'px; ' : '';
	$subtitle_line_height_style = !empty($subtitle_line_height) ? 'line-height:' . (int)$subtitle_line_height . 'px; ' : '';
	$subtitle_weight_style = !empty($subtitle_weight) ? 'font-weight:' . (int)$subtitle_weight . '; ' : '';
	$subtitle_color_style = !empty($subtitle_color && (bool)$custom_subtitle_color) ? 'color:' . esc_attr($subtitle_color) . '; ' : '';

	// Font Size of subTitle
	if (!empty($subtitle_size_style) || !empty($subtitle_line_height_style) || !empty($subtitle_weight_style) || !empty($subtitle_color_style) || !empty($subtitle_font_style)) {
		$subtitle_styles = 'style="'.$subtitle_size_style.$subtitle_line_height_style.$subtitle_weight_style.$subtitle_color_style.$subtitle_font_style.'"';
	} 

	// bg title styles
	$bgtitle_size_style = !empty($bgtitle_size) ? 'font-size:' . (int)$bgtitle_size . 'px; ' : '';
	$bgtitle_line_height_responsive = !empty($bgtitle_line_height) ? round( ((int)$bgtitle_line_height / (int)$bgtitle_size), 3) : '';
	$bgtitle_line_height_style = !empty($bgtitle_line_height_responsive) ? 'line-height:' . $bgtitle_line_height_responsive . '; ' : '';
	$bgtitle_weight_style = !empty($bgtitle_weight) ? 'font-weight:' . (int)$bgtitle_weight . '; ' : '';
	$bgtitle_color_style = !empty($bgtitle_color && $custom_bgtitle_color) ? 'color:' . esc_attr($bgtitle_color) . '; ' : '';

	// Font Size of bg Title
	if (!empty($bgtitle_size_style) || !empty($bgtitle_line_height_style) || !empty($bgtitle_weight_style) || !empty($bgtitle_color_style) || !empty($bgtitle_font_style)) {
		$bgtitle_styles = 'style="'.$bgtitle_size_style.$bgtitle_line_height_style.$bgtitle_weight_style.$bgtitle_color_style.$bgtitle_font_style.'"';
	} 

	// Animation
	if (! empty($atts['css_animation'])) {
		$animation_class = $this->getCSSAnimation( $atts['css_animation'] );
	}

	// Wrapper classes
	$dbl_head_wrap_classes .= ' a'.$align;
	$dbl_head_wrap_classes .= ' '.$extra_class;
	$dbl_head_wrap_classes .= !empty($animation_class) ? ' '.$animation_class : '';

	// Title output
	if (!empty($title)) {
		$title_render .= '<div class="heading_title" '.$title_styles.'>';
		if ((bool)$responsive_font) {
			$title_render .= !empty($font_size_desctop) ? '<div class="heading_title_desctop" style="font-size:'.(int)$font_size_desctop.'px; line-height: ' . $title_line_height_responsive . ';">' : '';
			$title_render .= !empty($font_size_tablet) ? '<div class="heading_title_tablet" style="font-size:'.(int)$font_size_tablet.'px; line-height: ' . $title_line_height_responsive . ';">' : '';
			$title_render .= !empty($font_size_mobile) ? '<div class="heading_title_mobile" style="font-size:'.(int)$font_size_mobile.'px; line-height: ' . $title_line_height_responsive . ';">' : '';
		}
		switch ($title_tag) {
			case 'div':
				$title_render .= esc_html($title);
				break;
			default:
				$title_render .= '<'.esc_attr($title_tag).'>'.esc_html($title).'</'.esc_attr($title_tag).'>';
				break;
		}
		if ((bool)$responsive_font) {
			$title_render .= !empty($font_size_desctop) ? '</div>' : '';
			$title_render .= !empty($font_size_tablet) ? '</div>' : '';
			$title_render .= !empty($font_size_mobile) ? '</div>' : '';
		}
		$title_render .= '</div>';
	}

	// Subtitle output
	switch ($subtitle_tag) {
		case 'div':
			$subtitle_render .= !empty($subtitle) ? '<div class="heading_subtitle" '.$subtitle_styles.'>'.esc_html($subtitle).'</div>' : '';
			break;
		default:
			$subtitle_render .= !empty($subtitle) ? '<'.esc_attr($subtitle_tag).' class="heading_subtitle" '.$subtitle_styles.'>'.esc_html($subtitle).'</'.esc_attr($subtitle_tag).'>' : '';
			break;
	}
	
	// Bg title output
	if (!empty($bgtitle)) {
		$bgtitle_render .= '<div class="heading_bgtitle" '.$bgtitle_styles.'>';
		if ((bool)$bg_responsive_font) {
			$bgtitle_render .= !empty($bg_font_size_desctop) ? '<div class="heading_bgtitle_desctop" style="font-size:'.(int)$bg_font_size_desctop.'px; line-height: ' . $bgtitle_line_height_responsive . ';">' : '';
			$bgtitle_render .= !empty($bg_font_size_tablet) ? '<div class="heading_bgtitle_tablet" style="font-size:'.(int)$bg_font_size_tablet.'px; line-height: ' . $bgtitle_line_height_responsive . ';">' : '';
			$bgtitle_render .= !empty($bg_font_size_mobile) ? '<div class="heading_bgtitle_mobile" style="font-size:'.(int)$bg_font_size_mobile.'px; line-height: ' . $bgtitle_line_height_responsive . ';">' : '';
		}
		switch ($title_tag) {
			case 'div':
				$bgtitle_render .= esc_html($bgtitle);
				break;
			default:
				$bgtitle_render .= '<'.esc_attr($bgtitle_tag).'>'.esc_html($bgtitle).'</'.esc_attr($bgtitle_tag).'>';
				break;
		}
		if ((bool)$bg_responsive_font) {
			$bgtitle_render .= !empty($bg_font_size_desctop) ? '</div>' : '';
			$bgtitle_render .= !empty($bg_font_size_tablet) ? '</div>' : '';
			$bgtitle_render .= !empty($bg_font_size_mobile) ? '</div>' : '';
		}
		$bgtitle_render .= '</div>';
	}

	$output .= '<div '.esc_attr($dbl_attr).' class="genesisexpo_module_double_headings'.esc_attr($dbl_head_wrap_classes).'">';
		$output .= $bgtitle_render;
		$output .= $subtitle_render;
		$output .= $title_render;
	$output .= '</div>';

	echo GenesisExpo_Theme_Helper::render_html($output);		

?>  
