<?php

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

$defaults = array(
    'divider_width_units' => 'pixels',
    'width' => '',
    'width_percentages' => '',
	'height' => '2px',
    'divider_alignment' => 'left',
    'divider_color' => '#ececec',
    'add_divider_line' => 'false',
    'divider_line_alignment' => 'left',
    'divider_line_color' => $theme_color,
);
$atts = vc_shortcode_attribute_parse( $defaults, $atts );

extract($atts);
$output = $divider_alignment_class = $divider_line_alignment_class = '';

    // divider classes
    $divider_alignment_class = ' divider_alignment_'.$divider_alignment;
    $divider_line_alignment_class = ' divider_line_alignment_'.$divider_line_alignment;
    ?>
    
    <div class="genesisexpo_divider<?php echo esc_attr($divider_alignment_class); ?> ">
    <div class="genesisexpo_divider_line<?php echo esc_attr($divider_line_alignment_class); ?> ">
        
    <?php
    $divider_line_color = !empty($divider_line_color) ? $divider_line_color : 'transparent';
    $divider_color = !empty($divider_color) ? $divider_color : 'transparent';
    // divider styles
    if (!empty($height) || $height == '0') {
        if ($divider_width_units == 'pixels'){
            $output .= '<div class="genesisexpo_divider_custom" style="width:'.(int)$width.'px; height:'.(int)$height.'px; background-color:'.esc_attr($divider_color).';">';
        }
        if ($divider_width_units == 'percentages'){
            $output .= '<div class="genesisexpo_divider_custom" style="width:'.(int)$width.'%; height:'.(int)$height.'px; background-color:'.esc_attr($divider_color).';">';
        }
        if ($add_divider_line == 'true'){
            $output .= '<span class="divider_line" style="background-color:'.esc_attr($divider_line_color).';"></span>';               
        }
        $output .= '</div>';
    }
    
    $output .= '</div>';
    $output .= '</div>';
    
echo GenesisExpo_Theme_Helper::render_html( $output );

?>