<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

if (function_exists('vc_map')) {
// Add list item
    $main_font = GenesisExpo_Theme_Helper::get_option('main-font');
    vc_map(array(
        'name' => esc_html__('Message Box', 'genesisexpo'),
        'base' => 'wgl_message_box',
        'class' => 'genesisexpo_message_box',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_message_box',
        'content_element' => true,
        'description' => esc_html__('Message Box','genesisexpo'),
        'params' => array(
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Message Type', 'genesisexpo' ),
                'param_name'    => 'type',
                'value'         => array(
                    esc_html__( 'Informational', 'genesisexpo' ) => 'info',
                    esc_html__( 'Success', 'genesisexpo' )		 => 'success',
                    esc_html__( 'Warning', 'genesisexpo' )		 => 'warning',
                    esc_html__( 'Error', 'genesisexpo' )		 => 'error',
                    esc_html__( 'Custom', 'genesisexpo' )		 => 'custom',
                ),              
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'genesisexpo' ),
                'param_name' => 'icon_fontawesome',
                'value' => 'fa fa-adjust',
                'settings' => array(
                    'emptyIcon' => false,
                    'iconsPerPage' => 200,
                ),
                'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type'          => 'colorpicker',
                'heading'       => esc_html__( 'Message Color', 'genesisexpo' ),
                'param_name'    => 'icon_color',
                'value'         => $theme_color,
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title', 'genesisexpo'),
                'param_name' => 'title',
                'admin_label'   => true,
            ),  
            array(
                'type' => 'textarea',
                'heading' => esc_html__('Text', 'genesisexpo'),
                'param_name' => 'text',
            ),       
            array(
                'type'          => 'wgl_checkbox',
                'heading'       => esc_html__( 'Closable?', 'genesisexpo' ),
                'param_name'    => 'closable',
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Title Styles', 'genesisexpo'),
                'param_name' => 'h_title_styles',
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Title Tag', 'genesisexpo' ),
                'param_name'    => 'title_tag',
                'value'         => array(
                    esc_html__( 'Div', 'genesisexpo' )    => 'div',
                    esc_html__( 'Span', 'genesisexpo' )    => 'span',
                    esc_html__( 'H2', 'genesisexpo' )    => 'h2',
                    esc_html__( 'H3', 'genesisexpo' )    => 'h3',
                    esc_html__( 'H4', 'genesisexpo' )    => 'h4',
                    esc_html__( 'H5', 'genesisexpo' )    => 'h5',
                    esc_html__( 'H6', 'genesisexpo' )    => 'h6',
                ),
                'std' => 'h4',
                'group'         => esc_html__( 'Typography', 'genesisexpo' ),
                'description' => esc_html__( 'Choose your tag for title', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // title Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title Font Size', 'genesisexpo'),
                'param_name' => 'title_size',
                'value' => '',
                'description' => esc_html__( 'Enter title font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // Title Fonts
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for title', 'genesisexpo' ),
                'param_name' => 'custom_fonts_title',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_title',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_title',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Title Color', 'genesisexpo' ),
                'param_name' => 'custom_title_color',
                'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // title color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Title Color', 'genesisexpo'),
                'param_name' => 'title_color',
                'value' => $theme_color,
                'description' => esc_html__('Select title color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_title_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // text styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Text Styles', 'genesisexpo'),
                'param_name' => 'h_text_styles',
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Text Tag', 'genesisexpo' ),
                'param_name'    => 'text_tag',
                'value'         => array(
                    esc_html__( 'Div', 'genesisexpo' )    => 'div',
                    esc_html__( 'Span', 'genesisexpo' )    => 'span',
                    esc_html__( 'H2', 'genesisexpo' )    => 'h2',
                    esc_html__( 'H3', 'genesisexpo' )    => 'h3',
                    esc_html__( 'H4', 'genesisexpo' )    => 'h4',
                    esc_html__( 'H5', 'genesisexpo' )    => 'h5',
                    esc_html__( 'H6', 'genesisexpo' )    => 'h6',
                ),
                'std' => 'div',
                'group'         => esc_html__( 'Typography', 'genesisexpo' ),
                'description' => esc_html__( 'Choose your tag for text', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // text Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Text Font Size', 'genesisexpo'),
                'param_name' => 'text_size',
                'value' => '',
                'description' => esc_html__( 'Enter text font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // text Fonts
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for text', 'genesisexpo' ),
                'param_name' => 'custom_fonts_text',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_text',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_text',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
            ),
            // text color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Text Color', 'genesisexpo' ),
                'param_name' => 'custom_text_color',
                'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency'    => array(
                    'element'   => 'type',
                    'value' => 'custom'
                ),
            ),
            // text color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Text Color', 'genesisexpo'),
                'param_name' => 'text_color',
                'value' => '#000000',
                'description' => esc_html__('Select text color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_text_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),             
        )
    ));
    
    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_message_box extends WPBakeryShortCode {}
    } 
}
