<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Image Layers', 'genesisexpo'),
        'base' => 'wgl_image_layers',
        'class' => 'genesisexpo_image_layers',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_image_layers',
        'content_element' => true,
        'description' => esc_html__('Display Image Layers','genesisexpo'),
        'params' => array(
            // image styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Layers Settings', 'genesisexpo'),
                'param_name' => 'h_settings',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'param_group',
                'heading' => esc_html__( 'Values', 'genesisexpo' ),
                'param_name' => 'values',
                'description' => esc_html__( 'Enter values for graph', 'genesisexpo' ),
                'params' => array(
                    array(
                        'type'          => 'attach_image',
                        'heading'       => esc_html__( 'Thumbnail', 'genesisexpo' ),
                        'param_name'    => 'thumbnail',
                    ),
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Top Offset', 'genesisexpo' ),
                        'param_name'    => 'top_offset',
                        'edit_field_class' => 'vc_col-sm-6',
                        'description' => esc_html__( 'Enter offset in %, for example -100% or 100%', 'genesisexpo' ),
                    ),
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Left Offset', 'genesisexpo' ),
                        'param_name'    => 'left_offset',
                        'edit_field_class' => 'vc_col-sm-6',
                        'description' => esc_html__( 'Enter offset in %, for example -100% or 100%', 'genesisexpo' ),
                    ),          
                    array(
                        'type'          => 'dropdown',
                        'heading'       => esc_html__( 'Image Animation', 'genesisexpo' ),
                        'param_name'    => 'image_animation',
                        'edit_field_class' => 'vc_col-sm-6',
                        'value'         => array(
                            esc_html__( 'Fade In', 'genesisexpo' )      => 'fade_in',
                            esc_html__( 'Slide Up', 'genesisexpo' )      => 'slide_up',
                            esc_html__( 'Slide Down', 'genesisexpo' )     => 'slide_down',
                            esc_html__( 'Slide Left', 'genesisexpo' )     => 'slide_left',
                            esc_html__( 'Slide Right', 'genesisexpo' )     => 'slide_right',
                            esc_html__( 'Slide Big Up', 'genesisexpo' )      => 'slide_big_up',
                            esc_html__( 'Slide Big Down', 'genesisexpo' )     => 'slide_big_down',
                            esc_html__( 'Slide Big Left', 'genesisexpo' )     => 'slide_big_left',
                            esc_html__( 'Slide Big Right', 'genesisexpo' )     => 'slide_big_right',
                            esc_html__( 'Slide Big Right', 'genesisexpo' )     => 'slide_big_right',
                            esc_html__( 'Flip Horizontally', 'genesisexpo' )     => 'flip_x',
                            esc_html__( 'Flip Vertically', 'genesisexpo' )     => 'flip_y',
                            esc_html__( 'Zoom In', 'genesisexpo' )     => 'zoom_in',
                        ),
                    ),         
                    array(
                        'type'          => 'textfield',
                        'heading'       => esc_html__( 'Image z-index', 'genesisexpo' ),
                        'param_name'    => 'image_order',
                        'value'         => '1',
                        'edit_field_class' => 'vc_col-sm-6',
                    ),  
                ),
            ),
            // images interval
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Interval Images Appearing', 'genesisexpo'),
                'param_name' => 'interval',
                'value' => '600',
                'description' => esc_html__( 'Enter interval in milliseconds', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Transition Speed', 'genesisexpo'),
                'param_name' => 'transition',
                'value' => '800',
                'description' => esc_html__( 'Enter transition speed in milliseconds', 'genesisexpo' ),
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'Link', 'genesisexpo' ),
                'param_name' => 'link',
                'description' => esc_html__('Add link to button.', 'genesisexpo')
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Image_Layers extends WPBakeryShortCode {
        }
    }
}
