<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}
$theme_color = esc_attr( GenesisExpo_Theme_Helper::get_option("theme-custom-color") );
$theme_color_secondary	= esc_attr( GenesisExpo_Theme_Helper::get_option("theme-secondary-color") );
$header_font_color = esc_attr( GenesisExpo_Theme_Helper::get_option('header-font')['color'] );

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Counter', 'genesisexpo'),
        'base' => 'wgl_counter',
        'class' => 'genesisexpo_counter',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_counter',
        'content_element' => true,
        'description' => esc_html__('Counter','genesisexpo'),
        'params' => array(
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Counter Title', 'genesisexpo'),
                'param_name' => 'count_title',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-9',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Title Divider', 'genesisexpo' ),
                'param_name' => 'add_title_divider',
                'edit_field_class' => 'vc_col-sm-3 no-top-padding',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Counter Value Prefix', 'genesisexpo'),
                'description' => esc_html__('Enter prefix before counter number', 'genesisexpo'),
                'param_name' => 'count_prefix',
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Counter Value', 'genesisexpo'),
                'description' => esc_html__('Enter number without any special character', 'genesisexpo'),
                'param_name' => 'count_value',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Counter Value Suffix', 'genesisexpo'),
                'description' => esc_html__('Enter suffix after counter number', 'genesisexpo'),
                'param_name' => 'count_suffix',
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Counter Type', 'genesisexpo'),
                'param_name' => 'counter_type',
                'fields' => array(
                    'default' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/type_def.png',
                        'label' => esc_html__('Default', 'genesisexpo')),
                    'bordered' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/type_bordered.png',
                        'label' => esc_html__('Bordered', 'genesisexpo')),
                    'fill' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/type_fill.png',
                        'label' => esc_html__('Fill', 'genesisexpo')),
                ),
                'value' => 'default',
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Counter Layout', 'genesisexpo'),
                'param_name' => 'counter_layout',
                'fields' => array(
                    'top' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/style_def.png',
                        'label' => esc_html__('Top', 'genesisexpo')),
                    'left' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/style_left.png',
                        'label' => esc_html__('Left', 'genesisexpo')),
                    'right' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/style_right.png',
                        'label' => esc_html__('Right', 'genesisexpo')),
                    'top_left' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/style_left_top.png',
                        'label' => esc_html__('Top Left', 'genesisexpo')),
                    'top_right' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/style_right_top.png',
                        'label' => esc_html__('Top Right', 'genesisexpo')),
                ),
                'value' => 'top',
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => array('default', 'bordered', 'fill')
                ),
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Alignment', 'genesisexpo' ),
                'param_name'    => 'counter_align',
                'value'         => array(
                    esc_html__( 'Left', 'genesisexpo' )		=> 'left',
                    esc_html__( 'Right', 'genesisexpo' )	=> 'right',
                    esc_html__( 'Center', 'genesisexpo' )	=> 'center',
                ),
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // Counter Icon/Image heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Icon Type', 'genesisexpo'),
                'param_name' => 'h_icon_type',
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            // Counter Icon/Image
            array(
                'type'          => 'dropdown',
                'param_name'    => 'icon_type',
                'value'         => array(
                    esc_html__( 'None', 'genesisexpo' )      => 'none',
                    esc_html__( 'Font', 'genesisexpo' )      => 'font',
                    esc_html__( 'Image', 'genesisexpo' )     => 'image',
                ),
                'save_always' => true,
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type'          => 'dropdown',
                'param_name'    => 'icon_font_type',
                'value'         => array(
                    esc_html__( 'Fontawesome', 'genesisexpo' )      => 'type_fontawesome',
                    esc_html__( 'Flaticon', 'genesisexpo' )      => 'type_flaticon',
                ),
                'save_always' => true,
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'genesisexpo' ),
                'param_name' => 'icon_fontawesome',
                'value' => 'fa fa-adjust', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false,
                    // default true, display an 'EMPTY' icon?
                    'iconsPerPage' => 200,
                    // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_font_type',
                    'value' => 'type_fontawesome',
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'genesisexpo' ),
                'param_name' => 'icon_flaticon',
                'value' => '', // default value to backend editor admin_label
                'settings' => array(
                    'emptyIcon' => false,
                    // default true, display an 'EMPTY' icon?
                    'type' => 'flaticon',
                    'iconsPerPage' => 200,
                    // default 100, how many icons per/page to display, we use (big number) to display all icons in single page
                ),
                'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_font_type',
                    'value' => 'type_flaticon',
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__( 'Image', 'genesisexpo' ),
                'param_name' => 'thumbnail',
                'value' => '',
                'description' => esc_html__( 'Select image from media library.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'image',
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            // Custom image width
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Image Width', 'genesisexpo'),
                'param_name' => 'custom_image_width',
                'description' => esc_html__( 'Enter image size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'image',
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Custom image height
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Image Height', 'genesisexpo'),
                'param_name' => 'custom_image_height',
                'description' => esc_html__( 'Enter image size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'image',
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Custom icon size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Icon Size', 'genesisexpo'),
                'param_name' => 'custom_icon_size',
                'description' => esc_html__( 'Enter Icon size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font',
                ),
            ),
            // Icon color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Icon Colors', 'genesisexpo' ),
                'param_name' => 'custom_icon_color',
                'description' => esc_html__( 'Select custom colors', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font',
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Icon color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Icon Color', 'genesisexpo'),
                'param_name' => 'icon_color',
                'value' => '#000000',
                'description' => esc_html__('Select icon color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_icon_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Icon hover color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Icon Hover Color', 'genesisexpo'),
                'param_name' => 'icon_color_hover',
                'description' => esc_html__('Select icon hover color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_icon_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),    
            // icon/image bg
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('For The Types with Icon Background', 'genesisexpo'),
                'param_name' => 'h_icon_bg',
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            // Custom icon bg size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Background Width', 'genesisexpo'),
                'param_name' => 'custom_icon_bg_width',
                'description' => esc_html__( 'Custom width in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Custom icon bg size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Background Height', 'genesisexpo'),
                'param_name' => 'custom_icon_bg_height',
                'description' => esc_html__( 'Custom height in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Bottom Offset', 'genesisexpo'),
                'param_name' => 'custom_icon_bot_offset',
                'description' => esc_html__( 'Custom offset in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ), 
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Side Offset', 'genesisexpo'),
                'param_name' => 'custom_icon_side_offset',
                'description' => esc_html__( 'It works only with layout left or right', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'counter_layout',
                    'value' => array('left','right','top_left','top_right'),
                ),
            ),  
            // Custom icon bg radius
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Enter Border Radius', 'genesisexpo'),
                'param_name' => 'custom_icon_radius',
                'description' => esc_html__( 'Custom radius in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => array('bordered','fill')
                ),
            ),   
            // icon/image border styles
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Border Styles', 'genesisexpo'),
                'param_name' => 'h_border_styles',
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => 'bordered'
                ),
            ),
            // Custom icon border width
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Border Width', 'genesisexpo'),
                'param_name' => 'border_width',
                'description' => esc_html__( 'Enter border width in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => 'bordered'
                ),
            ),
            // border color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Border Colors', 'genesisexpo' ),
                'param_name' => 'custom_border_color',
                'description' => esc_html__( 'Select custom colors', 'genesisexpo' ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => 'bordered'
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // border color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Border Color', 'genesisexpo'),
                'param_name' => 'border_color',
                'value' => '#000000',
                'description' => esc_html__('Select border color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_border_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // border hover color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Border Hover Color', 'genesisexpo'),
                'param_name' => 'border_color_hover',
                'description' => esc_html__('Select border hover color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_border_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ), 
            // icon/image bg styles
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Styles', 'genesisexpo'),
                'param_name' => 'h_bg_styles',
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => array('bordered','fill')
                ),
            ),
            // Background color/gradient
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Background Customize Colors', 'genesisexpo' ),
                'param_name'    => 'bg_color_type',
                'value'         => array(
                    esc_html__( 'Default', 'genesisexpo' )      => 'def',
                    esc_html__( 'Color', 'genesisexpo' )      => 'color',
                    esc_html__( 'Gradient', 'genesisexpo' )     => 'gradient',
                ),
                'dependency' => array(
                    'element' => 'counter_type',
                    'value' => array('bordered','fill')
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
            ),
            // background color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Color', 'genesisexpo'),
                'param_name' => 'background_color',
                'value' => '#000000',
                'description' => esc_html__('Select background color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background hover color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Hover Color', 'genesisexpo'),
                'param_name' => 'background_color_hover',
                'description' => esc_html__('Select background hover color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ), 
            // background Gradient start
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Start Color', 'genesisexpo'),
                'param_name' => 'background_gradient_start',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient end
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background End Color', 'genesisexpo'),
                'param_name' => 'background_gradient_end',
                'value' => '#000000',
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient start
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Hover Start Color', 'genesisexpo'),
                'param_name' => 'background_gradient_hover_start',
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient end
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Hover End Color', 'genesisexpo'),
                'param_name' => 'background_gradient_hover_end',
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__( 'Background Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Title Styles', 'genesisexpo'),
                'param_name' => 'h_title_styles',
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type'       => 'dropdown',
                'heading'    => esc_html__( 'Counter Title Tag', 'genesisexpo' ),
                'param_name' => 'title_tag',
                'value'      => array(
                    esc_html__( 'Div', 'genesisexpo' )  => 'div',
                    esc_html__( 'H2', 'genesisexpo' )   => 'h2',
                    esc_html__( 'H3', 'genesisexpo' )   => 'h3',
                    esc_html__( 'H4', 'genesisexpo' )   => 'h4',
                    esc_html__( 'H5', 'genesisexpo' )   => 'h5',
                    esc_html__( 'H6', 'genesisexpo' )   => 'h6',
                    esc_html__( 'Span', 'genesisexpo' ) => 'span',
                ),
                'std' => 'div',
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'description' => esc_html__( 'Choose your tag for counter title', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Counter Title Weight', 'genesisexpo' ),
                'param_name'    => 'title_weight',
                'value'         => array(
                    esc_html__( 'Light', 'genesisexpo' )    => '300',
                    esc_html__( 'Regular', 'genesisexpo' )  => '400',
                    esc_html__( 'SemiBold', 'genesisexpo' ) => '600',
                    esc_html__( 'Bold', 'genesisexpo' )     => '700',
                ),
                'std' => '400',
                'group'         => esc_html__( 'Styling', 'genesisexpo' ),
                'description' => esc_html__( 'Choose your Weight for counter title', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title Font Size', 'genesisexpo'),
                'param_name' => 'title_size',
                'value' => '',
                'description' => esc_html__( 'Enter Counter title font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Title Fonts
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for counter title', 'genesisexpo' ),
                'param_name' => 'custom_fonts_title',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_title',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_title',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Title Color', 'genesisexpo' ),
                'param_name' => 'custom_title_color',
                'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title colorpicker
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Title Color', 'genesisexpo'),
                'param_name' => 'title_color',
                'value' => $theme_color_secondary,
                'description' => esc_html__('Select title color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_title_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // counter value styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Counter Value Styles', 'genesisexpo'),
                'param_name' => 'h_count_value_styles',
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Counter Value Weight', 'genesisexpo' ),
                'param_name'    => 'count_value_weight',
                'value'         => array(
                    esc_html__( 'Light', 'genesisexpo' )    => '300',
                    esc_html__( 'Regular', 'genesisexpo' )    => '400',
                    esc_html__( 'SemiBold', 'genesisexpo' )    => '600',
                    esc_html__( 'Bold', 'genesisexpo' )    => '700',
                ),
                'std' => '700',
                'group'         => esc_html__( 'Styling', 'genesisexpo' ),
                'description' => esc_html__( 'Choose your Weight for counter value', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // counter value Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Counter Value Font Size', 'genesisexpo'),
                'param_name' => 'count_value_size',
                'value' => '',
                'description' => esc_html__( 'Enter Counter counter value font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Counter Value Fonts
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for counter value', 'genesisexpo' ),
                'param_name' => 'custom_fonts_count_value',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_count_value',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_count_value',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
            ),
            // counter value color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Counter Value Color', 'genesisexpo' ),
                'param_name' => 'custom_count_value_color',
                'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // counter value color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Counter Value Color', 'genesisexpo'),
                'param_name' => 'count_value_color',
                'value' => $header_font_color,
                'description' => esc_html__('Select counter value color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_count_value_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Styling', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Counter extends WPBakeryShortCode {
        }
    }
}