<?php

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

if (function_exists('vc_map')) {
    vc_map(array(		
		
        'base' => 'wgl_carousel',
        'name' => esc_html__('Carousel', 'genesisexpo'),
		'class' => 'genesisexpo_carousel_module',
        'content_element' => true,      
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_carousel',
        'show_settings_on_create' => true,
        'is_container' => true,
		'as_parent' => array('only' => 'wgl_counter, wgl_button, vc_column_text, wgl_pricing_table, wgl_info_box, wgl_custom_text, vc_single_image, vc_tta_tabs, vc_tta_tour, vc_tta_accordion, vc_images_carousel, vc_gallery, vc_message, vc_row, wgl_flip_box'),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Carousel Columns', 'genesisexpo'),
                'admin_label' => true,
                'param_name' => 'slide_to_show',
                'value' => array(
                    esc_html__('1', 'genesisexpo') => '1',
                    esc_html__('2', 'genesisexpo') => '2',
                    esc_html__('3', 'genesisexpo') => '3',
                    esc_html__('4', 'genesisexpo') => '4',
                    esc_html__('5', 'genesisexpo') => '5',
                    esc_html__('6', 'genesisexpo') => '6',
                )
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Speed', 'genesisexpo' ),
                'param_name' => 'speed',
                'value' => '300',
                'description' => esc_html__( 'Animation speed(ms)', 'genesisexpo' ),
            ),              
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Autoplay', 'genesisexpo' ),
                'param_name' => 'autoplay',
                'value' => array( esc_html__( 'Yes', 'genesisexpo' ) => 'yes' ),
                'edit_field_class' => 'vc_col-sm-4',
                'std' => 'yes'
            ),
            array(
                "type"          => "textfield",
                "heading"       => esc_html__( 'Autoplay Speed', 'genesisexpo' ),
                "param_name"    => "autoplay_speed",
                "dependency"    => array(
                    "element"   => "autoplay",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                "value"         => "3000",
                'group' => esc_html__( 'Carousel', 'genesisexpo' ),
            ),                 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Adaptive', 'genesisexpo' ),
                'param_name' => 'adaptive_height',
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'slide_to_show',
                    'value' => array('1'),
                ),
            ),     

            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Slide One Item by Click', 'genesisexpo' ),
                'param_name' => 'slides_to_scroll',
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Infinite loop sliding', 'genesisexpo' ),
                'param_name' => 'infinite',
                'edit_field_class' => 'vc_col-sm-4',
            ),

            vc_map_add_css_animation( true ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Pagination Controls', 'genesisexpo'),
                'param_name' => 'h_pag_controls',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Pagination control', 'genesisexpo' ),
                'param_name' => 'use_pagination',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'std' => 'true'
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Pagination Type', 'genesisexpo'),
                'param_name' => 'pag_type',
                'fields' => array(
                    'circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle.png',
                        'label' => esc_html__('Circle', 'genesisexpo')),
                    'circle_border' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle_border.png',
                        'label' => esc_html__('Empty Circle', 'genesisexpo')),
                    'square' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_square.png',
                        'label' => esc_html__('Square', 'genesisexpo')),
                    'line' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line.png',
                        'label' => esc_html__('Line', 'genesisexpo')),
                    'line_circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line_circle.png',
                        'label' => esc_html__('Line - Circle', 'genesisexpo')),
                ),
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'value' => 'circle',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Pagination Top Offset', 'genesisexpo' ),
                'param_name' => 'pag_offset',
                'value' => '',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Enter pagination top offset in pixels.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Pagination Aligning', 'genesisexpo'),
                'param_name' => 'pag_align',
                'value' => array(
                    esc_html__('Left', 'genesisexpo') => 'left',
                    esc_html__('Right', 'genesisexpo') => 'right',
                    esc_html__('Center', 'genesisexpo') => 'center',
                ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'std' => 'center',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Pagination Color', 'genesisexpo' ),
                'param_name' => 'custom_pag_color',
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Pagination Color', 'genesisexpo'),
                'param_name' => 'pag_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_pag_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // carousel prev/next heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Prev/Next Buttons', 'genesisexpo'),
                'param_name' => 'h_buttons',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Prev/Next buttons', 'genesisexpo' ),
                'param_name' => 'use_prev_next',
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Pagination Top Offset', 'genesisexpo' ),
                'param_name' => 'buttons_offset',
                'value' => '50%',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-8',
                'description' => esc_html__( 'Enter buttons top offset in percentages.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_prev_next',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'param_name' => 'h_buttons',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'dependency' => array(
                    'element' => 'use_prev_next',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom Buttons Color', 'genesisexpo' ),
                'param_name' => 'custom_buttons_color',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'use_prev_next',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Prev/Next Buttons Color', 'genesisexpo'),
                'param_name' => 'buttons_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_buttons_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Buttons Background Color', 'genesisexpo'),
                'param_name' => 'buttons_bg_color',
                'value' => '#ffffff',
                'dependency' => array(
                    'element' => 'custom_buttons_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Navigation', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Customize Responsive', 'genesisexpo' ),
                'param_name' => 'custom_resp',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
            ),
            // medium desktop
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Medium Desktop', 'genesisexpo'),
                'param_name' => 'h_resp_medium',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_medium',
                'value' => '1025',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_medium_slides',
                'value' => '',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            
            // tablets
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Tablets', 'genesisexpo'),
                'param_name' => 'h_resp_tablets',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_tablets',
                'value' => '800',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_tablets_slides',
                'value' => '',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            // mobile phones
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Mobile Phones', 'genesisexpo'),
                'param_name' => 'h_resp_mobile',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
                'param_name' => 'resp_mobile',
                'value' => '480',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
                'param_name' => 'resp_mobile_slides',
                'value' => '',
                'group' => esc_html__( 'Responsive', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            )			
        ),
		'js_view' => 'VcColumnView'
    ));


    if (class_exists('WPBakeryShortCodesContainer')) {
        class WPBakeryShortCode_wgl_carousel extends WPBakeryShortCodesContainer {}
    }
}