<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = GenesisExpo_Theme_Helper::get_option('theme-secondary-color');

if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Button', 'genesisexpo'),
        'base' => 'wgl_button',
        'class' => 'genesisexpo_button',
        'icon' => 'wgl_icon_button',
        'content_element' => true,
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'description' => esc_html__('Add extended button','genesisexpo'),
        'params' => array(
            // General Settings
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Text', 'genesisexpo'),
                'value' => esc_html__('Button Text', 'genesisexpo'),
                'param_name' => 'button_text',
                'admin_label' => true,
            ),
            array(
                'type' => 'vc_link',
                'heading' => esc_html__( 'Button Link', 'genesisexpo' ),
                'param_name' => 'link',
            ),
            // Button Animations
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
            // Button Style
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Style', 'genesisexpo'),
                'param_name' => 'h_button_style',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Button Size', 'genesisexpo' ),
                'param_name' => 'size',
                'value'         => array(
                    esc_html__( 'Small', 'genesisexpo' )	   => 's',
                    esc_html__( 'Medium', 'genesisexpo' )	   => 'm',
                    esc_html__( 'Large', 'genesisexpo' )	   => 'l',
                    esc_html__( 'Extra Large', 'genesisexpo' ) => 'xl',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'std' => 'xl',
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__('Select button size.', 'genesisexpo')
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Border Radius', 'genesisexpo'),
                'value' => '50px',
                'param_name' => 'border_radius',
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'description' => esc_html__('Enter border radius in pixels.', 'genesisexpo')
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Button Align', 'genesisexpo' ),
                'param_name' => 'align',
                'value'         => array(
                    esc_html__( 'Left', 'genesisexpo' )   => 'left',
                    esc_html__( 'Right', 'genesisexpo' )  => 'right',
                    esc_html__( 'Center', 'genesisexpo' ) => 'center',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__('Select button align.', 'genesisexpo')
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Button Full Width', 'genesisexpo' ),
                'param_name' => 'full_width',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ), 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Button Inline', 'genesisexpo' ),
                'param_name' => 'inline',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-3',
            ), 
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Border', 'genesisexpo'),
                'param_name' => 'h_button_border',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Button Border', 'genesisexpo' ),
                'param_name' => 'add_border',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
                'std' => 'true'
            ), 
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Border Width', 'genesisexpo'),
                'value' => '1px',
                'param_name' => 'border_width',
                'dependency' => array(
                    'element' => 'add_border',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-8',
                'description' => esc_html__('Enter border width in pixels.', 'genesisexpo')
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Shadow', 'genesisexpo'),
                'param_name' => 'h_button_shadow',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Button Shadow Style', 'genesisexpo' ),
                'param_name' => 'shadow_style',
                'value'         => array(
					esc_html__( 'None', 'genesisexpo' )			=> 'none',
					esc_html__( 'Always', 'genesisexpo' )		=> 'always',
					esc_html__( 'On Hover', 'genesisexpo' )		=> 'on_hover',
					esc_html__( 'Before Hover', 'genesisexpo' ) => 'before_hover',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'description' => esc_html__('Select button shadow style.', 'genesisexpo')
            ),
            // Button Typography
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for button', 'genesisexpo' ),
                'param_name' => 'custom_fonts_button',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_button',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_button',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Font Size', 'genesisexpo'),
                'param_name' => 'font_size',
                'value' => '',
                'description' => esc_html__( 'Enter button font-size in pixels.', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),            
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Font Weight', 'genesisexpo'),
                'param_name' => 'font_weight',
                'value' => '',
                'description' => esc_html__( 'Enter button font-weight.', 'genesisexpo' ),
                'group' => esc_html__( 'Typography', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Button Icon
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Icon Type', 'genesisexpo'),
                'param_name' => 'h_icon_type',
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'param_name' => 'icon_type',
                'value' => array(
                    esc_html__('None','genesisexpo') => 'none',
                    esc_html__('Font','genesisexpo') => 'font',
                    esc_html__('Image','genesisexpo') => 'image',
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'description' => esc_html__('Select button icon type (font icon or custom image)', 'genesisexpo'),
            ),
            array(
                'type'          => 'dropdown',
                'param_name'    => 'icon_font_type',
                'value'         => array(
                    esc_html__( 'Fontawesome', 'genesisexpo' )      => 'type_fontawesome',
                    esc_html__( 'Flaticon', 'genesisexpo' )      => 'type_flaticon',
                ),
                'save_always' => true,
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font',
                ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__('Icon', 'genesisexpo'),
                'param_name' => 'icon_fontawesome',
                'value' => 'fa fa-adjust',
                'settings' => array(
                    'emptyIcon' => false,
                    'iconsPerPage' => 200, 
                ),
                'dependency' => array(
                    'element' => 'icon_font_type',
                    'value' => 'type_fontawesome',
                ),
                'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'iconpicker',
                'heading' => esc_html__( 'Icon', 'genesisexpo' ),
                'param_name' => 'icon_flaticon',
                'value' => '',
                'settings' => array(
                    'emptyIcon' => false,
                    'type' => 'flaticon',
                    'iconsPerPage' => 200,
                ),
                'description' => esc_html__( 'Select icon from library.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_font_type',
                    'value' => 'type_flaticon',
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'attach_image',
                'heading' => esc_html__('Image', 'genesisexpo'),
                'param_name' => 'image',
                'value' => '',
                'description' => esc_html__( 'Select image from media library.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'image'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Image Width', 'genesisexpo'),
                'param_name' => 'img_width',
                'value' => '',
                'description' => esc_html__( 'Enter image width in pixels.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'image'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Icon Position', 'genesisexpo'),
                'param_name' => 'icon_position',
                'value' => array(
                    esc_html__('Left', 'genesisexpo') => 'left',
                    esc_html__('Right', 'genesisexpo') => 'right'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Select button icon position.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => array('image', 'font')
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Icon Font Size', 'genesisexpo'),
                'param_name' => 'icon_font_size',
                'value' => '',
                'edit_field_class' => 'vc_col-sm-6',
                'description' => esc_html__( 'Enter icon font-size in pixels.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
            ),
            // Button icon-color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Use Custom Colors', 'genesisexpo' ),
                'param_name' => 'custom_icon_color',
                'description' => esc_html__( 'Select custom colors', 'genesisexpo' ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'icon_type',
                    'value' => 'font'
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Button icon-color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Icon Color', 'genesisexpo'),
                'param_name' => 'icon_color',
                'value' => '#ffffff',
                'description' => esc_html__('Select icon color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_icon_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Button Hover icon-color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Hover Icon Color', 'genesisexpo'),
                'param_name' => 'icon_color_hover',
                'value' => '#ffffff',
                'description' => esc_html__('Select icon hover color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'custom_icon_color',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Icon', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // Button Spacing
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Paddings', 'genesisexpo'),
                'param_name' => 'heading',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Left Padding', 'genesisexpo'),
                'param_name' => 'left_pad',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button left padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Right Padding', 'genesisexpo'),
                'param_name' => 'right_pad',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button right padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Top Padding', 'genesisexpo'),
                'param_name' => 'top_pad',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button top padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Bottom Padding', 'genesisexpo'),
                'param_name' => 'bottom_pad',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button bottom padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Margins', 'genesisexpo'),
                'param_name' => 'heading',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Left Margin', 'genesisexpo'),
                'param_name' => 'left_mar',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button left margin in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Right Margin', 'genesisexpo'),
                'param_name' => 'right_mar',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button right margin in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Top Margin', 'genesisexpo'),
                'param_name' => 'top_mar',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button top margin in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Button Bottom Margin', 'genesisexpo'),
                'param_name' => 'bottom_mar',
                'value' => '',
                'group' => esc_html__( 'Spacing', 'genesisexpo' ),
                'description' => esc_html__( 'Enter button bottom margin in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Button Colors
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Button Colors', 'genesisexpo'),
                'param_name' => 'h_button_colors',
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Customize', 'genesisexpo' ),
                'param_name' => 'customize',
                'value'         => array(
                    esc_html__( 'Default', 'genesisexpo' )        => 'def',
                    esc_html__( 'Color', 'genesisexpo' )          => 'color',
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Text Color', 'genesisexpo'),
                'param_name' => 'h_text_color',
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Text Color', 'genesisexpo'),
                'param_name' => 'text_color',
                'value' => '#ffffff',
                'description' => esc_html__('Select custom text color for button.', 'genesisexpo'),
                'save_always' => true,
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Hover Text Color', 'genesisexpo'),
                'param_name' => 'text_color_hover',
                'value' => $theme_color,
                'description' => esc_html__('Select custom text color for hover button.', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Color', 'genesisexpo'),
                'param_name' => 'h_background_color',
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Background', 'genesisexpo'),
                'param_name' => 'bg_color',
                'value' => $theme_color,
                'description' => esc_html__('Select custom background for button.', 'genesisexpo'),
                'save_always' => true,
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Hover Background', 'genesisexpo'),
                'param_name' => 'bg_color_hover',
                'value' => '#ffffff',
                'description' => esc_html__('Select custom background for hover button.', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Border Color', 'genesisexpo'),
                'param_name' => 'h_border_color',
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Border Color', 'genesisexpo'),
                'param_name' => 'border_color',
                'value' => $theme_color,
                'description' => esc_html__('Select custom border color for button.', 'genesisexpo'),
                'save_always' => true,
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Hover Border Color', 'genesisexpo'),
                'param_name' => 'border_color_hover',
                'value' => $theme_color,
                'description' => esc_html__('Select custom border color for hover button.', 'genesisexpo'),
                'group' => esc_html__( 'Colors', 'genesisexpo' ),
                'save_always' => true,
                'dependency' => array(
                    'element' => 'customize',
                    'value' => 'color'
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
        )
    ));

    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_Button extends WPBakeryShortCode {
        }
    }
}