<?php

use GenesisExpo_Theme_Helper as Theme;

$single = GenesisExpo_SinglePost::getInstance();
$single->set_data();
$single->set_data_cats();

$title = get_the_title();

$show_likes = Theme::get_option('single_likes');
$show_share = Theme::get_option('single_share');
$show_views = Theme::get_option('single_views');
$single_author_info = Theme::get_option('single_author_info');
$single_meta = Theme::get_option('single_meta');
$single_cats = Theme::get_option('single_meta_categories');
$featured_image = Theme::options_compare('post_hide_featured_image', 'mb_post_hide_featured_image', '1');
$single->set_post_views(get_the_ID());

$meta_args = [];
if ( !(bool) $single_meta ) {
    $meta_args['date'] = !(bool)Theme::get_option('single_meta_date');
    $meta_args['author'] = !(bool)Theme::get_option('single_meta_author');
    $meta_args['comments'] = !(bool)Theme::get_option('single_meta_comments');
    $meta_args['category'] = !(bool)Theme::get_option('single_meta_categories');
}

?>
<div class="blog-post blog-post-single-item format-<?php echo esc_attr($single->get_pf()); ?>">
    <div <?php post_class("single_meta"); ?>>
        <div class="item_wrapper">
            <div class="blog-post_content">
                <?php
                if (!(bool) $featured_image){
                    $single->render_featured(false, 'full', !(bool) $single_cats ? true : false );
                }

                // Post Meta render
                if ( !(bool) $single_meta ) {
                    $single->render_post_meta($meta_args);
                }

                echo '<h1 class="blog-post_title">', get_the_title(), '</h1>';

                the_content();

                wp_link_pages([
                    'before' => '<div class="page-link"><span class="pagger_info_text">' . esc_html__('Pages', 'genesisexpo') . ': </span>',
                    'after' => '</div>'
                ]);

                if (
                    has_tag()
                    || (bool) $show_views
                    || (bool) $show_share
                    || (bool) $show_likes
                ) {
                    echo '<div class="post_info single_post_info">';

                    if (
                        (bool) $show_likes
                        || (bool) $show_share
                        || (bool) $show_likes
                    ) {
                        echo '<div class="blog-post_meta-wrap">';
                    }

                    echo '<div class="tagcloud-wrapper">';
                        the_tags('<div class="tagcloud">', ' ', '</div>');
                    echo '</div>';

                    if (
                        (bool) $show_likes
                        || (bool) $show_share
                        || (bool) $show_likes
                    ) {
                        echo '<div class="blog-post_info-wrap">';
                    }

                        // Shares
                        if ( (bool) $show_share && function_exists('wgl_theme_helper') ) {
                            echo '<div class="blog-post_share-wrap">',
                                wgl_theme_helper()->render_post_list_share(),
                            '</div>';
                        }

                        // Views
                        if ( (bool) $show_views ) : ?>
                            <div class="blog-post_views-wrap">
                            <?php
                                $single->get_post_views(get_the_ID());
                            ?>
                            </div>
                            <?php
                        endif;

                        // Likes
                        if ( (bool) $show_likes ) {
                            echo '<div class="blog-post_likes-wrap">';
                            if ( (bool) $show_likes && function_exists('wgl_simple_likes')) {
                                echo wgl_simple_likes()->likes_button( get_the_ID(), 0 );
                            }
                            echo '</div>';
                        }

                    if (
                        (bool) $show_likes
                        || (bool) $show_share
                        || (bool) $show_likes
                    ) {
                        echo '</div>';
                        echo '</div>';

                    }

                    echo '</div>';
                } else {

                    echo '<div class="divider_post_info"></div>';

                }
                if ( (bool) $single_author_info ) {
                    $single->render_author_info();
                }

                ?>
                <div class="clear"></div>
            </div>
        </div>
    </div>
</div>