<?php

defined('ABSPATH') || exit;

if (!class_exists('GenesisExpo_Theme_Support')) {
    /**
     * GenesisExpo Theme Support
     *
     *
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     * @version 1.2.16
     */
    class GenesisExpo_Theme_Support
    {
        private static $instance;
        private static $minimum_php_version = '7.0';

        /**
         * @since 1.0.0
         * @version 1.2.16
         */
        public function __construct()
        {
            if (version_compare(PHP_VERSION, self::$minimum_php_version, '<')) {
                add_action('admin_notices', [$this, 'fail_php_version']);
            }

            if (function_exists('add_theme_support')) {
                add_theme_support('post-thumbnails', array('post', 'page', 'port', 'team', 'testimonials', 'product', 'gallery'));
                add_theme_support('automatic-feed-links');
                add_theme_support('revisions');
                // Add support for full and wide align images.
                add_theme_support( 'align-wide' );
                // Add support for responsive embedded content.
                add_theme_support( 'responsive-embeds' );
                add_theme_support('post-formats', array('gallery', 'video', 'quote', 'audio', 'link'));
            }

            add_action('init', [$this, 'register_my_menus']);

            add_action('init', [$this, 'enqueue_translation_files']);

            // Add widget support
            add_action('widgets_init', [$this, 'sidebar_register']);
        }

        /**
         * @since 1.2.16
         */
        public function fail_php_version()
        {
            $message = sprintf(
                __('GenesisExpo theme requires PHP version %s+. Your current PHP version is %s.', 'genesisexpo'),
                self::$minimum_php_version,
                PHP_VERSION
            );

            echo '<div class="error"><p>', esc_html($message), '</p></div>';
        }

        public function register_my_menus()
        {
            register_nav_menus([
                'main_menu' => esc_html__('Main menu', 'genesisexpo'),
                'footer_menu' => esc_html__('Footer Menu', 'genesisexpo')
            ]);
        }

        public function enqueue_translation_files()
        {
            load_theme_textdomain('genesisexpo', get_template_directory() . '/languages/');
        }

        public function sidebar_register()
        {
            // Get List of registered sidebar
            $custom_sidebars = GenesisExpo_Theme_Helper::get_option('sidebars');

            // Default wrapper for widget and title
            $wrapper_before = '<div id="%1$s" class="widget genesisexpo_widget %2$s">';
            $wrapper_after = '</div>';
            $title_before = '<h3 class="widget-title">';
            $title_after = '</h3>';

            // Register custom sidebars
            if (!empty($custom_sidebars)) {
                foreach($custom_sidebars as $single){
                    register_sidebar( array(
                        'name' => esc_attr($single),
                        'id' => "sidebar_".esc_attr(strtolower(preg_replace('/[^A-Za-z0-9\-]/', '', str_replace(' ', '-', $single)))),
                        'description' => esc_html__('Add widget here to appear it in custom sidebar.', 'genesisexpo'),
                        'before_widget' => $wrapper_before,
                        'after_widget' => $wrapper_after,
                        'before_title' => $title_before,
                        'after_title' => $title_after,
                    ));
                }
            }

            // Register Footer Sidebar
            $footer_columns = [
                [
                    'name' => esc_html__('Footer Column 1', 'genesisexpo'),
                    'id' => 'footer_column_1'
                ], [
                    'name' => esc_html__('Footer Column 2', 'genesisexpo'),
                    'id' => 'footer_column_2'
                ], [
                    'name' => esc_html__('Footer Column 3', 'genesisexpo'),
                    'id' => 'footer_column_3'
                ], [
                    'name' => esc_html__('Footer Column 4', 'genesisexpo'),
                    'id' => 'footer_column_4'
                ],
            ];

            foreach ($footer_columns as $footer_column) {
                register_sidebar([
                    'name' => $footer_column['name'],
                    'id' => $footer_column['id'],
                    'description' => esc_html__('This area will display in footer like a column. Add widget here to appear it in footer column.', 'genesisexpo'),
                    'before_widget' => $wrapper_before,
                    'after_widget' => $wrapper_after,
                    'before_title' => $title_before,
                    'after_title' => $title_after,
                ]);
            }
            if (class_exists('WooCommerce')) {
                $shop_sidebars = [
                    [
                        'name' => esc_html__('Shop Products', 'genesisexpo'),
                        'id' => 'shop_products'
                    ], [
                        'name' => esc_html__('Shop Single', 'genesisexpo'),
                        'id' => 'shop_single'
                    ]
                ];
                foreach ($shop_sidebars as $shop_sidebar) {
                    register_sidebar([
                        'name' => $shop_sidebar['name'],
                        'id' => $shop_sidebar['id'],
                        'description' => esc_html__('This sidebar will display in WooCommerce Pages.', 'genesisexpo'),
                        'before_widget' => $wrapper_before,
                        'after_widget' => $wrapper_after,
                        'before_title' => $title_before,
                        'after_title' => $title_after,
                    ]);
                }
            }
        }

        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }

    new GenesisExpo_Theme_Support();
}
