<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
/**
* GenesisExpo Theme Helper
*
*
* @class        GenesisExpo_Theme_Helper
* @version      1.0
* @category Class
* @author       WebGeniusLab
*/

if (!class_exists('GenesisExpo_Theme_Helper')) {
    class GenesisExpo_Theme_Helper{

        private static $instance = null;
        public static function get_instance( ) {
            if ( null == self::$instance ) {
                self::$instance = new self( );
            }

            return self::$instance;
        }

        function __construct () {
            $this->register_filter();
        }

        function register_filter () {
            add_filter( 'vc_iconpicker-type-flaticon', array($this , 'vc_iconpicker_type_flaticon' ) );

        }

        public static function get_option($name, $preset = null, $def_preset = null) {
            if (  class_exists( 'Redux' ) && class_exists( 'GenesisExpo_Core_Public' ) ) {
                $preset = $preset == 'default' ? null : $preset;

                if (!$preset) {

                    // Customizer
                    if (!empty($GLOBALS['genesisexpo']) && $GLOBALS['genesisexpo'] != NULL) {
                        $theme_options = $GLOBALS['genesisexpo'];
                    } else {
                        $theme_options = get_option( 'genesisexpo' );
                    }

                } else {
                    $theme_options = get_option( 'genesisexpo_preset' );
                }

                if (empty($theme_options)) {
                    $theme_options = get_option( 'genesisexpo_default_options' );
                }

                if(!$preset){
                    return isset($theme_options[$name]) ? $theme_options[$name] : null;
                }

                if(!empty($def_preset)){
                    return isset($theme_options['default'][$preset][$name]) ? $theme_options['default'][$preset][$name] : null;
                }else{
                    return isset($theme_options[$preset][$name]) ? $theme_options[$preset][$name] : null;
                }


            }else{
                $default_option = get_option( 'genesisexpo_default_options' );
                return isset($default_option[$name]) ? $default_option[$name] : null;
            }
        }

        public static function options_compare($name,$check_key = false,$check_value = false){
            $option = self::get_option($name);
            $id = !is_archive() ? get_queried_object_id() : 0;
            if (class_exists( 'RWMB_Loader' ) && 0 !== $id) {
                //Check if check_key exist
                if ($check_key) {
                    if (rwmb_meta($check_key) == $check_value ) {
                        $option = rwmb_meta('mb_'.$name);
                    }
                }else{
                    $var = rwmb_meta('mb_'.$name);
                    $option = !empty($var) ? rwmb_meta('mb_'.$name) : self::get_option($name);
                }
            }
            return $option;
        }

        public static function bg_render($name,$check_key = false,$check_value = false){
            $image = GenesisExpo_Theme_Helper::get_option($name."_bg_image");
            $id = !is_archive() ? get_queried_object_id() : 0;
            //Get image src
            $src = !empty($image['background-image']) ? $image['background-image'] : '';

            //Get image repeat
            $repeat = !empty($image['background-repeat']) ? $image['background-repeat'] : '';
            //Get image size
            $size = !empty($image['background-size']) ? $image['background-size'] : '';

            //Get image attachment
            $attachment = !empty($image['background-attachment']) ? $image['background-attachment'] : '';

            //Get image position
            $position = !empty($image['background-position']) ? $image['background-position'] : '';

            if (class_exists( 'RWMB_Loader' ) && 0 !== $id) {

                $conditional_logic = rwmb_meta($check_key);

                if ($conditional_logic == 'on') {

                    $repeat = $size = $attachment = $position  = '';
                        //Get metaboxes image src
                    $src = rwmb_meta('mb_'.$name.'_bg')['image'];

                    //Check if metaboxes image exist
                    if (!empty($src)) {
                            //Get metaboxes image repeat
                        $repeat = rwmb_meta('mb_'.$name.'_bg')['repeat'];
                        $repeat = !empty($repeat) ? $repeat : '';

                            //Get metaboxes image size
                        $size = rwmb_meta('mb_'.$name.'_bg')['size'];
                        $size = !empty($size) ? $size : '';

                            //Get metaboxes image attachment
                        $attachment = rwmb_meta('mb_'.$name.'_bg')['attachment'];
                        $attachment = !empty($attachment) ? $attachment : '';

                            //Get metaboxes image position
                        $position = rwmb_meta('mb_'.$name.'_bg')['position'];
                        $position = !empty($position) ? $position : '';

                    }
                }
            }

            //Background render
            $style = '';
            $style .= !empty($src) ? 'background-image:url('.esc_url($src).');' : '';

            if (!empty($src)) {
                $style .= !empty($size) ? ' background-size:'.esc_attr($size).';' : '';
                $style .= !empty($repeat) ? ' background-repeat:'.esc_attr($repeat).';' : '';
                $style .= !empty($attachment) ? ' background-attachment:'.esc_attr($attachment).';' : '';
                $style .= !empty($position) ? ' background-position:'.esc_attr($position).';' : '';
            }
            return $style;
        }

        public static function preloader(){
            if (self::get_option('preloader') == '1' || self::get_option('preloader') == true) {
                $preloader_background = self::get_option('preloader_background');

                $preloader_color_1 = self::get_option('preloader_color_1');
                $preloader_color_2 = self::get_option('preloader_color_2');
                $preloader_color_3 = self::get_option('preloader_color_3');

                $bg_styles = !empty($preloader_background) ? ' style=background-color:'.$preloader_background.';' : "";
                $circle_color_1 = !empty($preloader_color_1) ? ' style=border-bottom-color:'.$preloader_color_1.';' : "";
                $circle_color_2 = !empty($preloader_color_2) ? ' style=border-right-color:'.$preloader_color_2.';' : "";
                $circle_color_3 = !empty($preloader_color_3) ? ' style=border-top-color:'.$preloader_color_3.';' : "";

                echo '<!-- Preloader -->';
                echo '<div id="preloader-wrapper" '.esc_attr($bg_styles).'>';
                echo '<div class="preloader-container">';
                    echo '<div class="cssload-loader">';
                      echo '<div class="cssload-inner cssload-one" '.esc_attr($circle_color_1).'></div>';
                      echo '<div class="cssload-inner cssload-two" '.esc_attr($circle_color_2).'></div>';
                      echo '<div class="cssload-inner cssload-three" '.esc_attr($circle_color_3).'></div>';
                    echo '</div>';
                echo '</div>';
                echo '</div>';
            }
        }

        public static function pagination($range = 5, $query = false, $alignment = 'center'){
            if ( $query != false ) {
                $wp_query = $query;
            } else {
                global $paged, $wp_query;
            }
            if (empty($paged)) {
                $query_vars = $wp_query->query_vars;
                $paged = isset($query_vars['paged']) ? $query_vars['paged'] : 1;
            }

            $output = '';
            $max_page = $wp_query->max_num_pages;


            // Exit if pagination not need
            if ( !($max_page > 1) ) return;

            switch ($alignment) {
                case 'left':
                    $class_alignment = '';
                    break;
                case 'right':
                    $class_alignment = 'a-right';
                    break;
                case 'center':
                    $class_alignment = 'a-center';
                    break;
                default:
                    $class_alignment = '';
                    break;
            }

            //return $output;
            $big = 999999999;

            $test_pag = paginate_links(array(
                'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
                'type' => 'array',
                'current'    => max( 1, $paged ),
                'total'      => $max_page,
                'prev_text' => '<i class="fa fa-angle-left"></i>',
                'next_text' => '<i class="fa fa-angle-right"></i>',
            ));
            $test_comp = '';
            foreach ($test_pag as $key => $value) {
                $test_comp .= '<li class="page">'.$value.'</li>';
            }
            return '<ul class="wgl-pagination '.esc_attr($class_alignment).'">'.$test_comp.'</ul>';
        }

        public static function hexToRGB($hex = "#ffffff"){
            $color = array();
            if (strlen($hex) < 1) {
                $hex = "#ffffff";
            }
            $color['r'] = hexdec(substr($hex, 1, 2));
            $color['g'] = hexdec(substr($hex, 3, 2));
            $color['b'] = hexdec(substr($hex, 5, 2));
            return $color['r'] . "," . $color['g'] . "," . $color['b'];
        }
        //https://github.com/opensolutions/smarty/blob/master/plugins/modifier.truncate.php
        public static function modifier_character($string, $length = 80, $etc = '... ', $break_words = false) {
            if ($length == 0)
                return '';

            if (mb_strlen($string, 'utf8') > $length) {
                $length -= mb_strlen($etc, 'utf8');
                if (!$break_words) {
                    $string = preg_replace('/\s+\S+\s*$/su', '', mb_substr($string, 0, $length + 1, 'utf8'));
                }
                return mb_substr($string, 0, $length, 'utf8') . $etc;
            } else {
                return $string;
            }
        }

        public static function load_more($range = 5, $query = false, $alignment = 'left', $name_load_more = '', $class = ''){
            $out = '';
            $name_load_more = !empty($name_load_more) ? $name_load_more : esc_html__("Load More", "genesisexpo");
            $out .= '<div class="clear"></div><div class="text-center load_more_wrapper'.(!empty($class) ? " ".esc_attr($class) : "" ).'"><a href="#" class="load_more_item"><span>' . esc_html($name_load_more) . '</span></a>';

            $uniq = uniqid();
            $ajax_data_str = htmlspecialchars( json_encode( $query ), ENT_QUOTES, 'UTF-8' );
            $out .= "<form class='posts_grid_ajax'>";
                $out .= "<input type='hidden' class='ajax_data' name='".esc_attr($uniq)."_ajax_data' value='$ajax_data_str' />";
            $out .= "</form>";
            $out .= "</div>";

            return $out;
        }

        public static function header_preset_name(){
            $id = !is_archive() ? get_queried_object_id() : 0;
            $name_preset = '';

            //Redux options header
            $name_preset = self::get_option('header_def_js_preset');
            $get_def_name = get_option( 'genesisexpo_preset' );
            if( !self::in_array_r($name_preset, get_option( 'genesisexpo_preset' ))){
                $name_preset = 'default';
            }

            //Metaboxes options header
            if (class_exists( 'RWMB_Loader' ) && $id !== 0) {
                $customize_header = rwmb_meta('mb_customize_header');
                if (!empty($customize_header) && rwmb_meta('mb_customize_header') != 'default') {
                    $name_preset = rwmb_meta('mb_customize_header');
                    if( !self::in_array_r($name_preset, get_option( 'genesisexpo_preset' ))){
                        $name_preset = 'default';
                    }
                }
            }
            return $name_preset;
        }

        public static function render_html ($args) {
            return isset($args) ? $args : '';
        }

        public static function in_array_r($needle, $haystack, $strict = false) {
            if(is_array($haystack)){
                foreach ($haystack as $item) {
                    if (($strict ? $item === $needle : $item == $needle) || (is_array($item) && self::in_array_r($needle, $item, $strict))) {
                        return true;
                    }
                }
            }

            return false;
        }

        public static function render_sidebars($args = 'page'){
            $output = array();
            $sidebar_style = '';

            $layout = self::get_option( $args.'_sidebar_layout');
            $sidebar = self::get_option( $args.'_sidebar_def');
            $sidebar_width = self::get_option($args.'_sidebar_def_width');
            $sticky_sidebar = self::get_option($args.'_sidebar_sticky');
            $sidebar_gap = self::get_option($args.'_sidebar_gap');
            $sidebar_class = $sidebar_style = '';
            $id = !is_archive() ? get_queried_object_id() : 0;

            $genesisexpo_core = class_exists('GenesisExpo_Core');

            if ( is_archive() || is_search() || is_home() || is_page()) {
                if(!$genesisexpo_core){
                    if(is_active_sidebar( 'sidebar_main-sidebar' )){
                        $layout = 'right';
                        $sidebar = 'sidebar_main-sidebar';
                        $sidebar_width = 8;
                    }
                }
            }

            if(is_single()){

                if(!$genesisexpo_core){
                    if(is_active_sidebar( 'sidebar_main-sidebar' )){
                        $layout = 'right';
                        $sidebar = 'sidebar_main-sidebar';
                        $sidebar_width = 8;
                    }
                }
            }

            if ( class_exists( 'RWMB_Loader' ) && 0 !== $id ) {
                $mb_layout = rwmb_meta('mb_page_sidebar_layout');
                if (!empty($mb_layout) && $mb_layout != 'default') {
                    $layout = $mb_layout;
                    $sidebar = rwmb_meta('mb_page_sidebar_def');
                    $sidebar_width = rwmb_meta('mb_page_sidebar_def_width');
                    $sticky_sidebar = rwmb_meta('mb_sticky_sidebar');
                    $sidebar_gap = rwmb_meta('mb_sidebar_gap');
                }
            }

            if((bool)$sticky_sidebar){
                wp_enqueue_script('theia-sticky-sidebar', get_template_directory_uri() . '/js/theia-sticky-sidebar.min.js', array(), false, false);
                $sidebar_class .= 'sticky-sidebar';
            }

            if (isset($sidebar_gap) && $sidebar_gap != 'def' && $layout != 'default') {
                $layout_pos = $layout == 'left' ? 'right' : 'left';
                $sidebar_style = 'style="padding-'.$layout_pos.': '.$sidebar_gap.'px;"';
            }

            $column = 12;
            if ( $layout == 'left' || $layout == 'right' ) {
                $column = (int) $sidebar_width;
            } else {
                $sidebar = '';
            }

            $output['column'] = $column;
            $output['row_class'] = $layout != 'none' ? ' sidebar_'.esc_attr($layout) : '';
            $output['layout'] = $layout;
            $output['content'] = '';

            if ($layout == 'left' || $layout == 'right') {
                if (is_active_sidebar( $sidebar )) {
                    $output['content'] .= '<div class="sidebar-container '.$sidebar_class.' wgl_col-'.(12 - (int)$column).'" '.$sidebar_style.'>';
                        $output['content'] .= "<aside class='sidebar'>";
                            ob_start();
                                dynamic_sidebar( $sidebar );
                            $output['content'] .= ob_get_clean();
                        $output['content'] .= "</aside>";
                    $output['content'] .= "</div>";
                }
            }
            return $output;
        }

        public static function posted_meta_on(){
            global $post;
            $text_string = '<span><time class="entry-date published" datetime="%1$s">%2$s</time></span><span>' . esc_html__('Published in', 'genesisexpo') . ' <a href="%3$s" rel="gallery">%4$s</a></span>';

            echo sprintf($text_string,
                esc_attr(get_the_date('c')),
                esc_html(get_the_date()),
                esc_url(get_permalink($post->post_parent)),
                esc_html(get_the_title($post->post_parent))
            );

            printf(
                '<span class="author vcard">%1$s</span>',
                sprintf(
                    '<a class="url fn n" href="%1$s">%2$s</a>',
                    esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
                    esc_html( get_the_author() )
                )
            );

            $metadata = wp_get_attachment_metadata();

            if ( $metadata ) {
                printf( '<span class="full-size-link"><span class="screen-reader-text">%1$s </span><a href="%2$s" title="%2$s">%1$s %3$s &times; %4$s</a></span>',
                    esc_html_x( 'Full size', 'Used before full size attachment link.', 'genesisexpo' ),
                    esc_url( wp_get_attachment_url() ),
                    esc_attr( absint( $metadata['width'] ) ),
                    esc_attr( absint( $metadata['height'] ) )
                );
            }

            $allowed_html = array(
                'span' => array(
                    'class' => true,
                ),
                'br' => array(),
                'em' => array(),
                'strong' => array()
            );
            edit_post_link(
                sprintf(
                    /* translators: %s: Name of current post */
                    wp_kses( __( 'Edit<span class="screen-reader-text"> "%s"</span>', 'genesisexpo' ), $allowed_html ),
                    get_the_title()
                ),
                '<span class="edit-link">','</span>'
            );
        }

        public function vc_iconpicker_type_flaticon( $icons ) {
            $flaticon_icons = array(
                array('flaticon-search' => 'flaticon-search'),
                array('flaticon-ticket' => 'flaticon-ticket'),
                array('flaticon-download' => 'flaticon-download'),
                array('flaticon-back' => 'flaticon-back'),
                array('flaticon-play' => 'flaticon-play'),
                array('flaticon-play-1' => 'flaticon-play-1'),
                array('flaticon-triangle' => 'flaticon-triangle'),
                array('flaticon-map' => 'flaticon-map'),
                array('flaticon-user' => 'flaticon-user'),
                array('flaticon-mail' => 'flaticon-mail'),
                array('flaticon-phone' => 'flaticon-phone'),
                array('flaticon-microphone' => 'flaticon-microphone'),
                array('flaticon-bag' => 'flaticon-bag'),
                array('flaticon-food' => 'flaticon-food'),
                array('flaticon-idea' => 'flaticon-idea'),
                array('flaticon-mouse' => 'flaticon-mouse'),
                array('flaticon-mouse-1' => 'flaticon-mouse-1'),
                array('flaticon-mouse-2' => 'flaticon-mouse-2'),
                array('flaticon-circle' => 'flaticon-circle'),
                array('flaticon-link' => 'flaticon-link'),
                array('flaticon-chain' => 'flaticon-chain'),
                array('flaticon-document' => 'flaticon-document'),
                array('flaticon-project' => 'flaticon-project'),
                array('flaticon-chat' => 'flaticon-chat'),
                array('flaticon-tag' => 'flaticon-tag'),
                array('flaticon-instagram' => 'flaticon-instagram'),
                array('flaticon-share' => 'flaticon-share'),
                array('flaticon-earth' => 'flaticon-earth'),
                array('flaticon-click' => 'flaticon-click'),
                array('flaticon-check' => 'flaticon-check'),
                array('flaticon-information-circular-button-symbol' => 'flaticon-information-circular-button-symbol'),
                array('flaticon-close-cross-circular-interface-button' => 'flaticon-close-cross-circular-interface-button'),
                array('flaticon-acceptance-circular-button' => 'flaticon-acceptance-circular-button'),
                array('flaticon-right-arrow-circular-button' => 'flaticon-right-arrow-circular-button'),
                array('flaticon-back-button' => 'flaticon-back-button'),
                array('flaticon-pin' => 'flaticon-pin'),
                array('flaticon-right-arrow' => 'flaticon-right-arrow'),
                array('flaticon-share-1' => 'flaticon-share-1'),
                array('flaticon-instagram-1' => 'flaticon-instagram-1'),
                array('flaticon-check-1' => 'flaticon-check-1'),
                array('flaticon-email' => 'flaticon-email'),
                array('flaticon-clock' => 'flaticon-clock'),
                array('flaticon-search-1' => 'flaticon-search-1'),
                array('flaticon-check-2' => 'flaticon-check-2'),
                array('flaticon-phone-call' => 'flaticon-phone-call'),
                array('flaticon-placeholder' => 'flaticon-placeholder'),
                array('flaticon-user-1' => 'flaticon-user-1'),
                array('flaticon-layers' => 'flaticon-layers'),
                array('flaticon-cube' => 'flaticon-cube'),
                array('flaticon-download-1' => 'flaticon-download-1'),
                array('flaticon-heart' => 'flaticon-heart'),
                array('flaticon-settings' => 'flaticon-settings'),
                array('flaticon-chat-1' => 'flaticon-chat-1'),
                array('flaticon-medal' => 'flaticon-medal'),
                array('flaticon-trash' => 'flaticon-trash'),
                array('flaticon-star' => 'flaticon-star'),
                array('flaticon-photo-camera' => 'flaticon-photo-camera'),
                array('flaticon-ticket-1' => 'flaticon-ticket-1'),
                array('flaticon-agreement' => 'flaticon-agreement'),
                array('flaticon-news' => 'flaticon-news'),
                array('flaticon-handshake' => 'flaticon-handshake'),
                array('flaticon-rocket' => 'flaticon-rocket'),
                array('flaticon-world' => 'flaticon-world'),
                array('flaticon-arrow' => 'flaticon-arrow'),
                array('flaticon-arrow-down-sign-to-navigate' => 'flaticon-arrow-down-sign-to-navigate'),
                array('flaticon-arrowhead-thin-outline-to-the-left' => 'flaticon-arrowhead-thin-outline-to-the-left'),
                array('flaticon-navigate-up-arrow' => 'flaticon-navigate-up-arrow'),
                array('flaticon-quotation-mark' => 'flaticon-quotation-mark'),
                array('flaticon-bag-1' => 'flaticon-bag-1'),
                array('flaticon-sale' => 'flaticon-sale'),
                array('flaticon-cart' => 'flaticon-cart'),
                array('flaticon-close' => 'flaticon-close'),
                array('flaticon-bag-2' => 'flaticon-bag-2'),
                array('flaticon-search-2' => 'flaticon-search-2'),
                array('flaticon-magnifying-glass' => 'flaticon-magnifying-glass'),
                array('flaticon-magnifying-glass-1' => 'flaticon-magnifying-glass-1'),
                array('flaticon-star-1' => 'flaticon-star-1'),
                array('flaticon-discount' => 'flaticon-discount'),
                array('flaticon-close-1' => 'flaticon-close-1'),
            );

            return array_merge( $icons, $flaticon_icons );
        }

        /**
         * Check licence activation
         */
        public static function wgl_theme_activated(){
            $licence_key = get_option( 'wgl_licence_validated' );
            $licence_key = empty( $licence_key ) ? get_option( Wgl_Theme_Verify::get_instance()->item_id ) : $licence_key;

            if( !empty($licence_key) ){
                return $licence_key;
            }

            return false;
        }

    }
    new GenesisExpo_Theme_Helper();
}
?>