<?php
if (!class_exists('GenesisExpo_Theme_Helper')) {
    return;
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');

if (function_exists('vc_map')) {
    vc_map(array(
        'base' => 'wgl_team',
        'name' => esc_html__('Team List', 'genesisexpo-core'),
        'description' => esc_html__('Show Team Grid', 'genesisexpo-core'),
        'icon' => 'wgl_icon_team',
        'category' => esc_html__('WGL Modules', 'genesisexpo-core'),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Team Grid Types', 'genesisexpo-core'),
                'param_name' => 'grid_types',
                'admin_label' => true,
                'value' => array(
                    esc_html__('Vertical', 'genesisexpo-core') => 'vert',
                    esc_html__('Horizontal', 'genesisexpo-core') => 'horiz',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Columns in Row', 'genesisexpo-core'),
                'param_name' => 'posts_per_line',
                'edit_field_class' => 'vc_col-sm-4',
                'admin_label' => true,
                'value' => array(
                    esc_html__('One', 'genesisexpo-core') => '1',
                    esc_html__('Two', 'genesisexpo-core') => '2',
                    esc_html__('Three', 'genesisexpo-core') => '3',
                    esc_html__('Four', 'genesisexpo-core') => '4',
                    esc_html__('Five', 'genesisexpo-core') => '5',
                ),
                'std' => '4'
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Team Info Alignment', 'genesisexpo-core'),
                'param_name' => 'info_align',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-4',
                'value' => array(
                    esc_html__('Left', 'genesisexpo-core') => 'left',
                    esc_html__('Right', 'genesisexpo-core') => 'right',
                    esc_html__('Center', 'genesisexpo-core') => 'center',
                ),
                'std' => 'center',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Gap Between Items', 'genesisexpo-core'),
                'param_name' => 'grid_gap',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-4',
                'value' => array(
                    esc_html__('0', 'genesisexpo-core') => '0',
                    esc_html__('2', 'genesisexpo-core') => '2',
                    esc_html__('4', 'genesisexpo-core') => '4',
                    esc_html__('6', 'genesisexpo-core') => '6',
                    esc_html__('10', 'genesisexpo-core') => '10',
                    esc_html__('20', 'genesisexpo-core') => '20',
                    esc_html__('30', 'genesisexpo-core') => '30',
                ),
                'std' => '30',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Link for Image', 'genesisexpo-core'),
                'param_name' => 'single_link_wrapper',
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Link for Heading', 'genesisexpo-core'),
                'param_name' => 'single_link_heading',
                'edit_field_class' => 'vc_col-sm-4',
                'std' => 'true',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Item Animation', 'genesisexpo-core'),
                'param_name' => 'item_animation',
                'edit_field_class' => 'vc_col-sm-6',
                'value' => array(
                    esc_html__('Default', 'genesisexpo-core') => 'def',
                    esc_html__('Move Up', 'genesisexpo-core') => 'moveup',
                    esc_html__('Grayscale', 'genesisexpo-core') => 'grayscale',
                ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Item Shadow', 'genesisexpo-core'),
                'param_name' => 'item_shadow',
                'edit_field_class' => 'vc_col-sm-6',
                'value' => array(
                    esc_html__('On Hover', 'genesisexpo-core') => 'on_hover',
                    esc_html__('Always', 'genesisexpo-core') => 'always',
                    esc_html__('None', 'genesisexpo-core') => 'none',
                ),
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Hide Meta', 'genesisexpo-core'),
                'param_name' => 'h_hide_meta',
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Hide Title', 'genesisexpo-core'),
                'param_name' => 'hide_title',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Hide Department', 'genesisexpo-core'),
                'param_name' => 'hide_department',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Hide Social Icons', 'genesisexpo-core'),
                'param_name' => 'hide_soc_icons',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Hide Content', 'genesisexpo-core'),
                'param_name' => 'hide_content',
                'edit_field_class' => 'vc_col-sm-3',
                'std' => 'true'
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Content Letters Count', 'genesisexpo-core'),
                'param_name' => 'letter_count',
                'value' => '100',
                "dependency" => array(
                    "element" => "hide_content",
                    'value_not_equal_to' => 'true'
                ),
            ),
            vc_map_add_css_animation(true),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo-core'),
                'param_name' => 'item_el_class',
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'genesisexpo-core')
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Add Carousel for Team Items', 'genesisexpo-core'),
                'param_name' => 'h_add_carousel',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                "group" => esc_html__("Carousel", 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Carousel', 'genesisexpo-core'),
                'param_name' => 'use_carousel',
                'edit_field_class' => 'vc_col-sm-4',
                "group" => esc_html__("Carousel", 'genesisexpo-core'),
            ),
            array(
                "type" => "wgl_checkbox",
                'heading' => esc_html__('Autoplay', 'genesisexpo-core'),
                "param_name" => "autoplay",
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__('Autoplay Speed', 'genesisexpo-core'),
                "param_name" => "autoplay_speed",
                "dependency" => array(
                    "element" => "autoplay",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                "value" => "3000",
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            array(
                "type" => "wgl_checkbox",
                'heading' => esc_html__('Multiple Items', 'genesisexpo-core'),
                "param_name" => "multiple_items",
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            array(
                "type" => "wgl_checkbox",
                'heading' => esc_html__('Scroll Items', 'genesisexpo-core'),
                "param_name" => "scroll_items",
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-6',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Pagination Controls', 'genesisexpo-core'),
                'param_name' => 'h_pag_controls',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Pagination control', 'genesisexpo-core'),
                'param_name' => 'use_pagination',
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Pagination Type', 'genesisexpo-core'),
                'param_name' => 'pag_type',
                'fields' => array(
                    'circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle.png',
                        'label' => esc_html__('Circle', 'genesisexpo-core')
                    ),
                    'circle_border' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle_border.png',
                        'label' => esc_html__('Empty Circle', 'genesisexpo-core')
                    ),
                    'square' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_square.png',
                        'label' => esc_html__('Square', 'genesisexpo-core')
                    ),
                    'line' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line.png',
                        'label' => esc_html__('Line', 'genesisexpo-core')
                    ),
                    'line_circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line_circle.png',
                        'label' => esc_html__('Line - Circle', 'genesisexpo-core')
                    ),
                ),
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'value' => 'circle',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Pagination Top Offset', 'genesisexpo-core'),
                'param_name' => 'pag_offset',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
                'description' => esc_html__('Enter pagination top offset in pixels.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Pagination Color', 'genesisexpo-core'),
                'param_name' => 'custom_pag_color',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Pagination Color', 'genesisexpo-core'),
                'param_name' => 'pag_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_pag_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // carousel arrows heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Arrows Controls', 'genesisexpo-core'),
                'param_name' => 'h_arrow_control',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Arrows control', 'genesisexpo-core'),
                'param_name' => 'use_prev_next',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Arrows Color', 'genesisexpo-core'),
                'param_name' => 'custom_buttons_color',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_prev_next',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Arrows Color', 'genesisexpo-core'),
                'param_name' => 'buttons_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_buttons_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // carousel responsive heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Responsive', 'genesisexpo-core'),
                'param_name' => 'h_resp',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Customize Responsive', 'genesisexpo-core'),
                'param_name' => 'custom_resp',
                "dependency" => array(
                    "element" => "use_carousel",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            // medium desktop
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Medium Desktop', 'genesisexpo-core'),
                'param_name' => 'h_resp_medium',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_medium',
                'value' => '1025',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_medium_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),

            // tablets
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Tablets', 'genesisexpo-core'),
                'param_name' => 'h_resp_tablets',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_tablets',
                'value' => '800',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_tablets_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            // mobile phones
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Mobile Phones', 'genesisexpo-core'),
                'param_name' => 'h_resp_mobile',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_mobile',
                'value' => '480',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_mobile_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Styles', 'genesisexpo-core'),
                'param_name' => 'h_bg_styles',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            // Background color
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Background Customize Colors', 'genesisexpo-core'),
                'param_name' => 'bg_color_type',
                'value' => array(
                    esc_html__('Default', 'genesisexpo-core') => 'def',
                    esc_html__('Color', 'genesisexpo-core') => 'color',
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
            ),
            // background hover color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Color', 'genesisexpo-core'),
                'param_name' => 'background_color',
                'value' => '#ffffff',
                'description' => esc_html__('Select background color', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Hover Color', 'genesisexpo-core'),
                'param_name' => 'background_hover_color',
                'value' => '#ffffff',
                'description' => esc_html__('Select background hover color', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Title Colors', 'genesisexpo-core'),
                'param_name' => 'h_title_styles',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Custom Title Color', 'genesisexpo-core'),
                'param_name' => 'custom_title_color',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Title Color', 'genesisexpo-core'),
                'param_name' => 'title_color',
                'value' => $header_font['color'],
                'dependency' => array(
                    'element' => 'custom_title_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Title Hover Color', 'genesisexpo-core'),
                'param_name' => 'title_hover_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_title_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Department Colors', 'genesisexpo-core'),
                'param_name' => 'h_depart_styles',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Custom Color', 'genesisexpo-core'),
                'param_name' => 'custom_depart_color',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Department Color', 'genesisexpo-core'),
                'param_name' => 'depart_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_depart_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Social Icons Colors', 'genesisexpo-core'),
                'param_name' => 'h_soc_styles',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Custom Color', 'genesisexpo-core'),
                'param_name' => 'custom_soc_color',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Social Icons Color', 'genesisexpo-core'),
                'param_name' => 'soc_color',
                'value' => '#cfd1df',
                'dependency' => array(
                    'element' => 'custom_soc_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Social Icons Hover Color', 'genesisexpo-core'),
                'param_name' => 'soc_hover_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_soc_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title styles heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Social Icons Colors', 'genesisexpo-core'),
                'param_name' => 'h_bg_soc_styles',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            // title color checkbox
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Use Custom Color', 'genesisexpo-core'),
                'param_name' => 'custom_soc_bg_color',
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // title color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Social Icons Color', 'genesisexpo-core'),
                'param_name' => 'soc_bg_color',
                'value' => '#f3f3f3',
                'dependency' => array(
                    'element' => 'custom_soc_bg_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Social Icons Hover Color', 'genesisexpo-core'),
                'param_name' => 'soc_bg_hover_color',
                'value' => '#f3f3f3',
                'dependency' => array(
                    'element' => 'custom_soc_bg_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Colors', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
        )
    ));
    GenesisExpo_Loop_Settings::init('wgl_team', array(
        'hide_cats' => true,
        'hide_tags' => true
    ));
    class WPBakeryShortCode_wgl_Team extends WPBakeryShortCode
    {
    }
}
