<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package genesisexpo-core\admin
 * @author WebGeniusLab <webgeniuslab@gmail.com>
 * @link https://themeforest.net/user/webgeniuslab
 * @since 1.0.0
 */
class GenesisExpo_Core_Admin
{
    private $plugin_name;
    private $plugin_version;

    public function __construct($plugin_name, $plugin_version)
    {
        $this->plugin_name = $plugin_name;
        $this->plugin_version = $plugin_version;
    }

    /**
     * @since 1.0.0
     */
    public function enqueue_styles()
    {
        wp_enqueue_style($this->plugin_name, plugin_dir_url(__FILE__) . 'css/wgl-core-admin.css', [], $this->plugin_version);
    }

    /**
     * @since 1.0.0
     * @version 1.2.10
     */
    public function enqueue_scripts()
    {
        wp_enqueue_script($this->plugin_name, plugin_dir_url(__FILE__) . 'js/wgl-core-admin.js', ['jquery'], $this->plugin_version);
        wp_enqueue_script('jquery-migrate', plugin_dir_url(__FILE__) . 'js/jquery-migrate-3.3.0.min.js', ['jquery'], '3.3.0');
    }
}
