<?php

    $theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

    $defaults = array(
        'values' => '',
        'extra_class' => '',
        // Carousel
        'slide_to_show' => '5',
        'slides_to_scroll' => false,
        'infinite' => false,
        'autoplay' => false,
        'autoplay_speed' => '3000',
        'use_pagination' => true,
        'pag_type' => 'circle',
        'pag_offset' => '',
        'pag_align' => 'center',
        'custom_pag_color' => false,
        'pag_color' => $theme_color,
        'custom_resp' => false,
        'resp_medium' => '1025',
        'resp_medium_slides' => '',
        'resp_tablets' => '800',
        'resp_tablets_slides' => '',
        'resp_mobile' => '480',
        'resp_mobile_slides' => '',
    );

    $atts = vc_shortcode_attribute_parse($defaults, $atts);
    extract($atts);

    // carousel options array
    $carousel_options_arr = array(
        'slide_to_show' => $slide_to_show,
        'autoplay' => $autoplay,
        'autoplay_speed' => $autoplay_speed,
        'use_pagination' => $use_pagination,
        'pag_type' => $pag_type,
        'pag_offset' => $pag_offset,
        'pag_align' => $pag_align,
        'custom_pag_color' => $custom_pag_color,
        'pag_color' => $pag_color,
        'custom_resp' => $custom_resp,
        'resp_medium' => $resp_medium,
        'resp_medium_slides' => $resp_medium_slides,
        'resp_tablets' => $resp_tablets,
        'resp_tablets_slides' => $resp_tablets_slides,
        'resp_mobile' => $resp_mobile,
        'resp_mobile_slides' => $resp_mobile_slides,
        'slides_to_scroll' => $slides_to_scroll,
        'infinite' => $infinite,
    );

    // carousel options
    $carousel_options = array_map(function($k, $v) { return "$k=\"$v\" "; }, array_keys($carousel_options_arr), $carousel_options_arr);
    $carousel_options = implode('', $carousel_options);

    wp_enqueue_script('slick', get_template_directory_uri() . '/js/slick.min.js', array(), false, false);

    $output = $content = $time_line_wrap_classes = $animation_class = '';

    // Animation
    if (!empty($atts['css_animation'])) {
        $animation_class = $this->getCSSAnimation( $atts['css_animation'] );
    }

    // social wrapper classes
    $time_line_wrap_classes .= !empty($animation_class) ? ' '.$animation_class : '';
    $time_line_wrap_classes .= !empty($extra_class) ? ' '.$extra_class : '';

    $values = (array) vc_param_group_parse_atts( $values );
    $item_data = array();
    foreach ( $values as $data ) {
        $new_data = $data;
        $new_data['title'] = isset( $data['title'] ) ? $data['title'] : '';
        $new_data['descr'] = isset( $data['descr'] ) ? $data['descr'] : '';
        $new_data['date'] = isset( $data['date'] ) ? $data['date'] : '';
        $new_data['circle_color'] = isset( $data['circle_color'] ) ? $data['circle_color'] : $theme_color;

        $item_data[] = $new_data;
    }

    foreach ( $item_data as $item_d ) {

        $circle_style = 'style="background: '.$item_d['circle_color'].';"';

        $content .= '<div class="time_line-item">';
            $content .= !empty($item_d['date']) ? '<h4 class="time_line-date">'.esc_html($item_d['date']).'</h4>' : '';
            $content .= '<div class="time_line-check_wrap"><div class="time_line-check">';
                $content .= '<span class="time_line-check_circle" '.$circle_style.'></span>';
            $content .= '</div></div>';
            $content .= !empty($item_d['title']) ? '<h4 class="time_line-title">'.esc_html($item_d['title']).'</h4>' : '';
            $content .= !empty($item_d['descr']) ? '<div class="time_line-descr">'.esc_html($item_d['descr']).'</div>' : '';
        $content .= '</div>';

    }

    $output .= '<div class="genesisexpo_module_time_line_horizontal'.esc_attr($time_line_wrap_classes).'">';
        $output .= do_shortcode('[wgl_carousel '.$carousel_options.']'.$content.'[/wgl_carousel]');
    $output .= '</div>';

    echo GenesisExpo_Theme_Helper::render_html($output);

?>