<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

$theme_color			= esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$theme_color_secondary	= esc_attr(GenesisExpo_Theme_Helper::get_option("theme-secondary-color"));

if (function_exists('vc_map')) {
	vc_map(array(
		'name' => esc_html__('Testimonials', 'genesisexpo'),
		'base' => 'wgl_testimonials',
		'class' => 'genesisexpo_testimonials',
		'category' => esc_html__('WGL Modules', 'genesisexpo'),
		'icon' => 'wgl_icon_testimonial',
		'content_element' => true,
		'description' => esc_html__('Feedback from the clients.','genesisexpo'),
		'params' => array(
			array(
				'type' => 'genesisexpo_radio_image',
				'heading' => esc_html__('Testimonials Type', 'genesisexpo'),
				'param_name' => 'item_type',
				'fields' => array(
					'default' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/testimonials_1.png',
						'label' => esc_html__('Default', 'genesisexpo')),
					'author_left_top' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/testimonials_2.png',
						'label' => esc_html__('Author Top Left', 'genesisexpo')),
					'author_left_bottom' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/testimonials_3.png',
						'label' => esc_html__('Author Bottom Left', 'genesisexpo')),
					'author_bottom' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/testimonials_3.png',
						'label' => esc_html__('Author Bottom', 'genesisexpo')),
				),
				'value' => 'default',
			),
			array(
				"type"			=> "dropdown",
				"heading"		=> esc_html__( 'Testimonials Grid', 'genesisexpo' ),
				"param_name"	=> "item_grid",
				"value"			=> array(
					esc_html__( 'One Column', 'genesisexpo' )    => '1',
					esc_html__( 'Two Columns', 'genesisexpo' )   => '2',
					esc_html__( 'Three Columns', 'genesisexpo' ) => '3',
					esc_html__( 'Four Columns', 'genesisexpo' )  => '4',
					esc_html__( 'Five Columns', 'genesisexpo' )  => '5',
				),              
			),
			array(
				'type'          => 'dropdown',
				'heading'       => esc_html__( 'Alignment', 'genesisexpo' ),
				'param_name'    => 'item_align',
				'value'         => array(
					esc_html__( 'Left', 'genesisexpo' )   => 'left',
					esc_html__( 'Center', 'genesisexpo' ) => 'center',
					esc_html__( 'Right', 'genesisexpo' )  => 'right',
				),
			),
			vc_map_add_css_animation( true ),
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Extra Class', 'genesisexpo'),
				'param_name' => 'extra_class',
				'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
			),
			array(
				'type' => 'param_group',
				'heading' => esc_html__( 'Values', 'genesisexpo' ),
				'description' => esc_html__( 'Enter values for graph - thumbnail, quote, author name and author status.', 'genesisexpo' ),
				'param_name' => 'values',
				'params' => array(
					array(
						"type"			=> "attach_image",
						"heading"		=> esc_html__( 'Thumbnail', 'genesisexpo' ),
						"param_name"	=> "thumbnail",
					),
					array(
						"type"			=> "textarea",
						"heading"		=> esc_html__( 'Quote', 'genesisexpo' ),
						"param_name"	=> "quote",
					),
					array(
						"type"			=> "textfield",
						"heading"		=> esc_html__( 'Author Name', 'genesisexpo' ),
						"param_name"	=> "author_name",
						'admin_label'	=> true,
					),
					array(
						"type"			=> "textfield",
						"heading"		=> esc_html__( 'Author Status', 'genesisexpo' ),
						"param_name"	=> "author_status",
					),
					array(
						"type"			=> "textfield",
						"heading"		=> esc_html__( 'Date', 'genesisexpo' ),
						"param_name"	=> "date",
					),
				),
				'group' => esc_html__( 'Items', 'genesisexpo' ),
			),
			// image styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Custom Image Styles', 'genesisexpo'),
				'param_name' => 'h_image_styles',
				'group' => esc_html__( 'Items', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			// Custom image size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Enter Image Width', 'genesisexpo'),
				'param_name' => 'custom_img_width',
				'description' => esc_html__( 'Custom width in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Items', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// Custom image size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Enter Image Height', 'genesisexpo'),
				'param_name' => 'custom_img_height',
				'description' => esc_html__( 'Custom height in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Items', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// Custom image radius
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Enter Image Radius', 'genesisexpo'),
				'param_name' => 'custom_img_radius',
				'description' => esc_html__( 'Custom radius in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Items', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// carousel heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Add Carousel for Testimonials Items', 'genesisexpo'),
				'param_name' => 'h_carousel',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
			),
			array(
				"type"          => "wgl_checkbox",
				'heading' => esc_html__( 'Use Carousel', 'genesisexpo' ),
				"param_name"    => "use_carousel",
				'edit_field_class' => 'vc_col-sm-4',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
			),
			array(
				"type"          => "wgl_checkbox",
				'heading' => esc_html__( 'Autoplay', 'genesisexpo' ),
				"param_name"    => "autoplay",
				"dependency"    => array(
					"element"   => "use_carousel",
					"value" => 'true'
				),
				'edit_field_class' => 'vc_col-sm-4',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
			),
			array(
				"type"		 => "textfield",
				"heading"	 => esc_html__( 'Autoplay Speed', 'genesisexpo' ),
				"param_name" => "autoplay_speed",
				"dependency" => array(
					"element" => "autoplay",
					"value"   => 'true'
				),
				'edit_field_class' => 'vc_col-sm-4',
				"value" => "3000",
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
			),
			// carousel pagination heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Pagination Controls', 'genesisexpo'),
				'param_name' => 'h_pag_controls',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				"dependency"    => array(
					"element"   => "use_carousel",
					"value" => 'true'
				),
			),
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Add Pagination control', 'genesisexpo' ),
				'param_name' => 'use_pagination',
				'edit_field_class' => 'vc_col-sm-12',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				"dependency"    => array(
					"element"   => "use_carousel",
					"value" => 'true'
				),
				'std' => 'true'
			),
			array(
				'type' => 'genesisexpo_radio_image',
				'heading' => esc_html__('Pagination Type', 'genesisexpo'),
				'param_name' => 'pag_type',
				'fields' => array(
					'circle' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle.png',
						'label' => esc_html__('Circle', 'genesisexpo')),
					'circle_border' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle_border.png',
						'label' => esc_html__('Empty Circle', 'genesisexpo')),
					'square' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_square.png',
						'label' => esc_html__('Square', 'genesisexpo')),
					'line' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line.png',
						'label' => esc_html__('Line', 'genesisexpo')),
					'line_circle' => array(
						'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line_circle.png',
						'label' => esc_html__('Line - Circle', 'genesisexpo')),
				),
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'use_pagination',
					'value' => 'true',
				),
				'value' => 'circle',
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Pagination Top Offset', 'genesisexpo' ),
				'param_name' => 'pag_offset',
				'value' => '',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'description' => esc_html__( 'Enter pagination top offset in pixels.', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'use_pagination',
					'value' => 'true',
				),
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__('Pagination Aligning', 'genesisexpo'),
				'param_name' => 'pag_align',
				'value' => array(
					esc_html__('Left', 'genesisexpo')	=> 'left',
					esc_html__('Right', 'genesisexpo')	=> 'right',
					esc_html__('Center', 'genesisexpo')	=> 'center',
				),
				'dependency' => array(
					'element' => 'use_pagination',
					'value' => 'true',
				),
				'edit_field_class' => 'vc_col-sm-6',
				'std' => 'center',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
			),
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Custom Pagination Color', 'genesisexpo' ),
				'param_name' => 'custom_pag_color',
				'edit_field_class' => 'vc_col-sm-6',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'dependency' => array(
					'element' => 'use_pagination',
					'value' => 'true',
				),
			),
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Pagination Color', 'genesisexpo'),
				'param_name' => 'pag_color',
				'value' => $theme_color,
				'dependency' => array(
					'element' => 'custom_pag_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// carousel pagination heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Responsive', 'genesisexpo'),
				'param_name' => 'h_resp',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				"dependency"    => array(
					"element"   => "use_carousel",
					"value" => 'true'
				),
			),
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Customize Responsive', 'genesisexpo' ),
				'param_name' => 'custom_resp',
				"dependency"  => array(
					"element" => "use_carousel",
					"value"	  => 'true'
				),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
			),
			// medium desktop
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Medium Desktop', 'genesisexpo'),
				'param_name' => 'h_resp_medium',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
				'param_name' => 'resp_medium',
				'value' => '1025',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
				'param_name' => 'resp_medium_slides',
				'value' => '',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			
			// tablets
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Tablets', 'genesisexpo'),
				'param_name' => 'h_resp_tablets',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
				'param_name' => 'resp_tablets',
				'value' => '800',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
				'param_name' => 'resp_tablets_slides',
				'value' => '',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			// mobile phones
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Mobile Phones', 'genesisexpo'),
				'param_name' => 'h_resp_mobile',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Screen resolution', 'genesisexpo' ),
				'param_name' => 'resp_mobile',
				'value' => '480',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			array(
				'type' => 'textfield',
				'heading' => esc_html__( 'Slides to show', 'genesisexpo' ),
				'param_name' => 'resp_mobile_slides',
				'value' => '',
				'group' => esc_html__( 'Carousel', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
				'dependency' => array(
					'element' => 'custom_resp',
					'value' => 'true',
				),
			),
			// quote styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Quote Styles', 'genesisexpo'),
				'param_name' => 'h_quote_styles',
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12 no-top-margin',
			),
			array(
				'type'          => 'dropdown',
				'heading'       => esc_html__( 'Quote Tag', 'genesisexpo' ),
				'param_name'    => 'quote_tag',
				'value'         => array(
					esc_html__( 'Div', 'genesisexpo' )	=> 'div',
					esc_html__( 'Span', 'genesisexpo' ) => 'span',
					esc_html__( 'H2', 'genesisexpo' )	=> 'h2',
					esc_html__( 'H3', 'genesisexpo' )	=> 'h3',
					esc_html__( 'H4', 'genesisexpo' )	=> 'h4',
					esc_html__( 'H5', 'genesisexpo' )	=> 'h5',
					esc_html__( 'H6', 'genesisexpo' )	=> 'h6',
				),
				'std' => 'div',
				'group'         => esc_html__( 'Styles', 'genesisexpo' ),
				'description' => esc_html__( 'Choose your tag for quote', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// quote Font Size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Quote Font Size', 'genesisexpo'),
				'param_name' => 'quote_size',
				'value' => '',
				'description' => esc_html__( 'Enter quote font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Quote Fonts
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Custom font family for quote', 'genesisexpo' ),
				'param_name' => 'custom_fonts_quote',
				'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts_quote',
				'value' => '',
				'dependency' => array(
					'element' => 'custom_fonts_quote',
					'value' => 'true',
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			// quote color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Quote Color', 'genesisexpo' ),
				'param_name' => 'custom_quote_color',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// quote color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Quote Color', 'genesisexpo'),
				'param_name' => 'quote_color',
				'value' => '#000000',
				'description' => esc_html__('Select quote color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_quote_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// author name styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Author Name Styles', 'genesisexpo'),
				'param_name' => 'h_name_styles',
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			array(
				'type'          => 'dropdown',
				'heading'       => esc_html__( 'Author Name Tag', 'genesisexpo' ),
				'param_name'    => 'name_tag',
				'value'         => array(
					esc_html__( 'Span', 'genesisexpo' )	=> 'span',
					esc_html__( 'Div', 'genesisexpo' )	=> 'div',
					esc_html__( 'H2', 'genesisexpo' )	=> 'h2',
					esc_html__( 'H3', 'genesisexpo' )	=> 'h3',
					esc_html__( 'H4', 'genesisexpo' )	=> 'h4',
					esc_html__( 'H5', 'genesisexpo' )	=> 'h5',
					esc_html__( 'H6', 'genesisexpo' )	=> 'h6',
				),
				'std' => 'h3',
				'group'         => esc_html__( 'Styles', 'genesisexpo' ),
				'description' => esc_html__( 'Choose your tag for author name', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// author name Font Size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Author Name Font Size', 'genesisexpo'),
				'param_name' => 'name_size',
				'value' => '',
				'description' => esc_html__( 'Enter author name font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// author name Fonts
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Custom font family for author name', 'genesisexpo' ),
				'param_name' => 'custom_fonts_name',
				'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts_name',
				'value' => '',
				'dependency' => array(
					'element' => 'custom_fonts_name',
					'value' => 'true',
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			// author name color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Author Name Color', 'genesisexpo' ),
				'param_name' => 'custom_name_color',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// author name color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Author Name Color', 'genesisexpo'),
				'param_name' => 'name_color',
				'value' => '#000000',
				'description' => esc_html__('Select author name color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_name_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// author status styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Author Status Styles', 'genesisexpo'),
				'param_name' => 'h_status_styles',
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			array(
				'type'          => 'dropdown',
				'heading'       => esc_html__( 'Author Status Tag', 'genesisexpo' ),
				'param_name'    => 'status_tag',
				'value'         => array(
					esc_html__( 'Span', 'genesisexpo' )	=> 'span',
					esc_html__( 'Div', 'genesisexpo' )	=> 'div',
					esc_html__( 'H2', 'genesisexpo' )	=> 'h2',
					esc_html__( 'H3', 'genesisexpo' )	=> 'h3',
					esc_html__( 'H4', 'genesisexpo' )	=> 'h4',
					esc_html__( 'H5', 'genesisexpo' )	=> 'h5',
					esc_html__( 'H6', 'genesisexpo' )	=> 'h6',
				),
				'std' => 'span',
				'group'         => esc_html__( 'Styles', 'genesisexpo' ),
				'description' => esc_html__( 'Choose your tag for author status', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// author status Font Size
			array(
				'type' => 'textfield',
				'heading' => esc_html__('Author Status Font Size', 'genesisexpo'),
				'param_name' => 'status_size',
				'value' => '',
				'description' => esc_html__( 'Enter author status font-size in pixels.', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// author status Fonts
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Custom font family for author status', 'genesisexpo' ),
				'param_name' => 'custom_fonts_status',
				'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			array(
				'type' => 'google_fonts',
				'param_name' => 'google_fonts_status',
				'value' => '',
				'dependency' => array(
					'element' => 'custom_fonts_status',
					'value' => 'true',
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
			),
			// author status color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Author Status Color', 'genesisexpo' ),
				'param_name' => 'custom_status_color',
				'value' => 'true',
				'description' => esc_html__( 'Select custom color', 'genesisexpo' ),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// author status color
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Author Status Color', 'genesisexpo'),
				'param_name' => 'status_color',
				'value' => $theme_color_secondary,
				'description' => esc_html__('Select author status color', 'genesisexpo'),
				'dependency' => array(
					'element' => 'custom_status_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// date styles heading
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Date Styles', 'genesisexpo'),
				'param_name' => 'h_date_styles',
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-12',
			),
			// date color checkbox
			array(
				'type' => 'wgl_checkbox',
				'heading' => esc_html__( 'Use Custom Date Color', 'genesisexpo' ),
				'description' => esc_html__( 'Select color', 'genesisexpo' ),
				'param_name' => 'custom_date_color',
				'value' => 'true',
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
			// date colorpicker
			array(
				'type' => 'colorpicker',
				'heading' => esc_html__('Date Color', 'genesisexpo'),
				'description' => esc_html__('Select color', 'genesisexpo'),
				'param_name' => 'date_color',
				'value' => '#afafaf',
				'dependency' => array(
					'element' => 'custom_date_color',
					'value' => 'true'
				),
				'group' => esc_html__( 'Styles', 'genesisexpo' ),
				'edit_field_class' => 'vc_col-sm-4',
			),
		)
	));

	if (class_exists('WPBakeryShortCode')) {
		class WPBakeryShortCode_wgl_Testimonials extends WPBakeryShortCode {}
	}
}
