<?php

$theme_gradient = GenesisExpo_Theme_Helper::get_option('theme-gradient');

if (function_exists('vc_map')) {
    vc_map(array(		
		
        'base' => 'wgl_ico_progress',
        'name' => esc_html__('Ico Progress', 'genesisexpo'),
		'class' => 'genesisexpo_ico_progress_module',
        'description' => esc_html__('Display Ico Progress Module', 'genesisexpo'),
        'as_parent' => array('only' => 'wgl_countdown, wgl_button, vc_column_text, wgl_custom_text, vc_single_image, vc_row , wgl_ico_progress_bar, wgl_spacing'),
		'content_element' => true,		
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_ico-mod',
		'show_settings_on_create' => true,
		'is_container' => true,
        'params' => array(
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Background Colors', 'genesisexpo'),
                'param_name' => 'h_bg_bg_colors',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type'          => 'dropdown',
                'heading'       => esc_html__( 'Background Customize Colors', 'genesisexpo' ),
                'param_name'    => 'bg_color_type',
                'value'         => array(
                    esc_html__( 'Default', 'genesisexpo' )      => 'def',
                    esc_html__( 'Color', 'genesisexpo' )      => 'color',
                    esc_html__( 'Gradient', 'genesisexpo' )     => 'gradient',
                ),
            ),	
            // background color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Color', 'genesisexpo'),
                'param_name' => 'bg_color',
                'value' => 'rgba(0,0,32,0.7)',
                'description' => esc_html__('Select background color', 'genesisexpo'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),	
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Start Color', 'genesisexpo'),
                'param_name' => 'bg_gradient_start',
                'value' => $theme_gradient['from'],
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient end
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background End Color', 'genesisexpo'),
                'param_name' => 'bg_gradient_end',
                'value' => $theme_gradient['to'],
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // button paddings
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Ico Paddings', 'genesisexpo'),
                'param_name' => 'heading',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Ico Left Padding', 'genesisexpo'),
                'param_name' => 'ico_left_pad',
                'value' => '30',
                'description' => esc_html__( 'Enter Ico left padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Ico Right Padding', 'genesisexpo'),
                'param_name' => 'ico_right_pad',
                'value' => '30',
                'description' => esc_html__( 'Enter Ico right padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Ico Top Padding', 'genesisexpo'),
                'param_name' => 'ico_top_pad',
                'value' => '30',
                'description' => esc_html__( 'Enter Ico top padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Ico Bottom Padding', 'genesisexpo'),
                'param_name' => 'ico_bottom_pad',
                'value' => '30',
                'description' => esc_html__( 'Enter Ico bottom padding in pixels.', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo'),
                'param_name' => 'extra_class',
                'description' => esc_html__('Add an extra class name to the element and refer to it from Custom CSS option.', 'genesisexpo')
            ),
        ),
		'js_view' => 'VcColumnView'
    ));


    if (class_exists('WPBakeryShortCodesContainer')) {
        class WPBakeryShortCode_wgl_Ico_Progress extends WPBakeryShortCodesContainer
        {
        }
    }
}