<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));

if (function_exists('vc_map')) {
// Add list item
    vc_map(array(
        'name' => esc_html__('Divider', 'genesisexpo'),
        'base' => 'wgl_divider',
        'class' => 'genesisexpo_divider',
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_divider', // need to change
        'content_element' => true,
        'description' => esc_html__('Divider', 'genesisexpo'),
        'params' => array(
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Divider Width Units', 'genesisexpo' ),
                'param_name' => 'divider_width_units',
                'value' => array(
                    esc_html__( 'Pixels', 'genesisexpo' )      => 'pixels',
                    esc_html__( 'Percentages', 'genesisexpo' )      => 'percentages',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Width', 'genesisexpo'),
                'param_name' => 'width',
                'description' => esc_html__('Enter empty space width', 'genesisexpo'),
                'value' => '',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'divider_width_units',
                    'value' => array(
                        'pixels',
                        'percentages',
                    ),
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Height', 'genesisexpo'),
                'param_name' => 'height',
                'description' => esc_html__('Enter empty space height', 'genesisexpo'),
                'value' => '2px',
                'save_always' => true,
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Divider Alignment', 'genesisexpo' ),
                'param_name' => 'divider_alignment',
                'value' => array(
                    esc_html__( 'Left', 'genesisexpo' )      => 'left',
                    esc_html__( 'Right', 'genesisexpo' )      => 'right',
                    esc_html__( 'Center', 'genesisexpo' )     => 'center',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Divider Color', 'genesisexpo' ),
                'param_name' => 'divider_color',
                'value' => '#ececec',
                'save_always' => true,
                'description' => esc_html__( 'Choose divider color.', 'genesisexpo' ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Add Divider Line', 'genesisexpo' ),
                'param_name' => 'add_divider_line',
                'group' => esc_html__( 'Divider Line', 'genesisexpo' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Divider Line Alignment', 'genesisexpo' ),
                'param_name' => 'divider_line_alignment',
                'value' => array(
                    esc_html__( 'Left', 'genesisexpo' )      => 'left',
                    esc_html__( 'Right', 'genesisexpo' )      => 'right',
                    esc_html__( 'Center', 'genesisexpo' )     => 'center',
                ),
                'dependency' => array(
                    'element' => 'add_divider_line',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Divider Line', 'genesisexpo' ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__( 'Divider Line Color', 'genesisexpo' ),
                'param_name' => 'divider_line_color',
                'value' => $theme_color,
                'save_always' => true,
                'description' => esc_html__( 'Choose divider line color.', 'genesisexpo' ),
                'dependency' => array(
                    'element' => 'add_divider_line',
                    'value' => 'true'
                ),
                'group' => esc_html__( 'Divider Line', 'genesisexpo' ),
            ),
        )
    ));
    
    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_divider extends WPBakeryShortCode {
            
        }
    }
}