<?php
if ( ! defined( 'ABSPATH' ) ) {
    die( '-1' );
}

$main_font = GenesisExpo_Theme_Helper::get_option('main-font');
$theme_color = esc_attr(GenesisExpo_Theme_Helper::get_option("theme-custom-color"));
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');
if (function_exists('vc_map')) {
    vc_map(array(
        'name' => esc_html__('Countdown Timer', 'genesisexpo'),
        'base' => 'wgl_countdown',
        'class' => 'genesisexpo_countdown',
        'content_element' => true,
        'description' => esc_html__('Countdown','genesisexpo'),
        'category' => esc_html__('WGL Modules', 'genesisexpo'),
        'icon' => 'wgl_icon_countdown',
        'params' => array(
            array(
                'type'          => 'genesisexpo_param_heading',
                'heading' => esc_html__('Countdown Date:', 'genesisexpo'),
                'param_name'    => 'h_date',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Year', 'genesisexpo'),
                'param_name' => 'countdown_year',
                'edit_field_class' => 'vc_col-sm-2',
                'description' => esc_html__('Enter year example: 2018', 'genesisexpo'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Month', 'genesisexpo'),
                'param_name' => 'countdown_month',
                'edit_field_class' => 'vc_col-sm-2',
                'description' => esc_html__('Enter month example: 03', 'genesisexpo'),
            ),            
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Day', 'genesisexpo'),
                'param_name' => 'countdown_day',
                'edit_field_class' => 'vc_col-sm-2',
                'description' => esc_html__('Enter day example: 28', 'genesisexpo'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Hours', 'genesisexpo'),
                'param_name' => 'countdown_hours', 
                'edit_field_class' => 'vc_col-sm-2',
                'description' => esc_html__('Enter hours example: 13', 'genesisexpo'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Minutes', 'genesisexpo'),
                'param_name' => 'countdown_min',
                'edit_field_class' => 'vc_col-sm-2',
                'description' => esc_html__('Enter min. example: 24', 'genesisexpo'),
            ), 
            array(
                "type"          => "genesisexpo_param_heading",
                "heading" => esc_html__("Countdown Hide:", 'genesisexpo'),
                "param_name"    => "h_hide",
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Hide Days?', 'genesisexpo' ),
                'param_name' => 'hide_day',
                'edit_field_class' => 'vc_col-sm-3',
            ),            
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Hide Hours?', 'genesisexpo' ),
                'param_name' => 'hide_hours',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Hide Minutes?', 'genesisexpo' ),
                'param_name' => 'hide_minutes',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Hide Seconds?', 'genesisexpo' ),
                'param_name' => 'hide_seconds',
                'edit_field_class' => 'vc_col-sm-3',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__( 'Custom font family for a countdown?', 'genesisexpo' ),
                'param_name' => 'custom_fonts_countdown',
                'description' => esc_html__( 'Customize font family', 'genesisexpo' ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_countdown',
                'value' => '',
                'dependency' => array(
                    'element' => 'custom_fonts_countdown',
                    'value' => 'true',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                "type" => "dropdown",
                "class" => "",
                "heading" => esc_html__("Size", 'genesisexpo'),
                "param_name" => "size",
                "value" => array(
                    esc_html__("Small",'genesisexpo') => "small",
                    esc_html__("Medium",'genesisexpo') => "medium",
                    esc_html__("Large",'genesisexpo') => "large",
                    esc_html__("Extra Large",'genesisexpo') => "e_large",
                    esc_html__("Custom",'genesisexpo') => "custom",
                ),
                'std'         => 'large', 
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Font Size', 'genesisexpo'),
                'param_name' => 'font_size',
                'description' => esc_html__('Enter font-size in pixels', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'size',
                    'value' => 'custom',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Font Size Numner', 'genesisexpo'),
                'param_name' => 'font_size_number',
                'description' => esc_html__('Enter font-size in em', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'size',
                    'value' => 'custom',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),           
             array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Font Size Text', 'genesisexpo'),
                'param_name' => 'font_size_text',
                'description' => esc_html__('Enter font-size in em', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
                'dependency' => array(
                    'element' => 'size',
                    'value' => 'custom',
                ),
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Number Weight', 'genesisexpo'),
                'param_name' => 'font_weight',
                'description' => esc_html__('Enter font-weight in pixels', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Custom Text Weight', 'genesisexpo'),
                'param_name' => 'font_text_weight',
                'description' => esc_html__('Enter font-weight in pixels', 'genesisexpo'),
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__( 'Align', 'genesisexpo' ),
                'param_name' => 'align',
                "value"         => array(
                    esc_html__( 'Left', 'genesisexpo' ) => 'left',
                    esc_html__( 'Center', 'genesisexpo' ) => 'center',
                    esc_html__( 'Right', 'genesisexpo' ) => 'right',
                ),
                'std' => 'center',
                'group' => esc_html__( 'Style', 'genesisexpo' ),
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Number Color', 'genesisexpo'),
                'param_name' => 'number_color',
                'value' => "#ffffff",
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ), 
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Text Color', 'genesisexpo'),
                'param_name' => 'countdown_color',
                'value' => "#ffffff",
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ), 
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Points Color', 'genesisexpo'),
                'param_name' => 'points_color',
                'value' => $theme_color,
                'group' => esc_html__( 'Style', 'genesisexpo' ),
                'edit_field_class' => 'vc_col-sm-4',
            ),                     
        )
    ));
    
    if (class_exists('WPBakeryShortCode')) {
        class WPBakeryShortCode_wgl_countdown extends WPBakeryShortCode {}
    } 
}