<?php

/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage GenesisExpo
 * @since 1.0.0
 * @version 1.2.9
 */

get_header();
$sb = GenesisExpo_Theme_Helper::render_sidebars();
$row_class = $sb['row_class'] ?? '';
$column = $sb['column'] ?? '';

?>
<div class="wgl-container">
    <div class="row<?php echo apply_filters('genesisexpo_row_class', $row_class); ?>">
        <div id='main-content' class="wgl_col-<?php echo apply_filters('genesisexpo_column_class', $column); ?>">
            <?php
                get_template_part('templates/post/posts-list');
                echo GenesisExpo_Theme_Helper::pagination();
            ?>
        </div>
        <?php
            echo !empty($sb['content']) ? $sb['content'] : '';
        ?>
    </div>
</div>
<?php

get_footer();
