<?php
if(!class_exists('GenesisExpo_Theme_Helper')){
    return;
}
$theme_color = GenesisExpo_Theme_Helper::get_option('theme-custom-color');
$theme_color_second = GenesisExpo_Theme_Helper::get_option('theme-secondary-color');
$header_font = GenesisExpo_Theme_Helper::get_option('header-font');
$main_font = GenesisExpo_Theme_Helper::get_option('main-font');
$theme_gradient_start = GenesisExpo_Theme_Helper::get_option('theme-gradient')['from'] ?? '';
$theme_gradient_end = GenesisExpo_Theme_Helper::get_option('theme-gradient')['to'] ?? '';

if (function_exists('vc_map')) {
    vc_map( array(
        "name" => esc_html__("Portfolio List", 'genesisexpo-core'),
        "base" => $this->shortcodeName,
        "class" => 'genesisexpo_portfolio_list',
        "category" => esc_html__('WGL Modules', 'genesisexpo-core'),
        "icon" => 'wgl_icon_portfolio_module',
        "content_element" => true,
        "description" => esc_html__("Portfolio List",'genesisexpo-core'),
        "params" => array(
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Layout', 'genesisexpo-core'),
                'param_name' => 'portfolio_layout',
                'fields' => array(
                    'grid' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_grid.png',
                        'label' => esc_html__('Grid', 'genesisexpo-core')),
                    'carousel' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_carousel.png',
                        'label' => esc_html__('Carousel', 'genesisexpo-core')),
                    'masonry' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_masonry.png',
                        'label' => esc_html__('Masonry', 'genesisexpo-core')),
                    'masonry2' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_masonry.png',
                        'label' => esc_html__('Masonry 2', 'genesisexpo-core')),
                    'masonry3' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_masonry.png',
                        'label' => esc_html__('Masonry 3', 'genesisexpo-core')),
                    'masonry4' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/layout_masonry.png',
                        'label' => esc_html__('Masonry 4', 'genesisexpo-core')),
                ),
                'value' => 'grid',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Column', 'genesisexpo-core'),
                'param_name' => 'posts_per_row',
                'admin_label' => true,
                'value' => array(
                    esc_html__("1", 'genesisexpo-core') => '1',
                    esc_html__("2", 'genesisexpo-core') => '2',
                    esc_html__("3", 'genesisexpo-core') => '3',
                    esc_html__("4", 'genesisexpo-core') => '4',
                    esc_html__("5", 'genesisexpo-core') => '5',
                ),
                'std' => '3',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => array('grid', 'masonry', 'carousel')
                ),
            ),            
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Filter', 'genesisexpo-core'),
                'param_name' => 'show_filter',
                'value' => array( esc_html__('Yes', 'genesisexpo-core') => 'yes' ),
                'std' => '',
                'save_always' => true,
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => array('grid', 'masonry', 'masonry2', 'masonry3')
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Filter Style', 'genesisexpo-core'),
                'param_name' => 'filter_style',
                'admin_label' => true,
                'value' => array(
                    esc_html__("Default", 'genesisexpo-core') => 'def',
                    esc_html__("With Background", 'genesisexpo-core') => 'with_bg',
                ),
                'dependency' => array(
                    'element' => 'show_filter',
                    "value" => "yes"
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ),   
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Filter Align', 'genesisexpo-core'),
                'param_name' => 'filter_align',
                'value' => array(
                    esc_html__("Left", 'genesisexpo-core') => 'left',
                    esc_html__("Right", 'genesisexpo-core') => 'right',
                    esc_html__("Center", 'genesisexpo-core') => 'center',
                ),
                'std' => 'center',
                'dependency' => array(
                    'element' => 'show_filter',
                    "value" => "yes"
                ),
                'edit_field_class' => 'vc_col-sm-4',
            ), 
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Crop Images', 'genesisexpo-core'),
                'param_name' => 'crop_images',
                'value' => array( esc_html__('Yes', 'genesisexpo-core') => 'yes' ),
                'std' => 'yes',
                'save_always' => true,
            ),            
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Pagination', 'genesisexpo-core'),
                'param_name' => 'view_style',
                'admin_label' => true,
                'save_always' => true,
                'value' => array(
                    esc_html__('Static', 'genesisexpo-core') => "standard",
                    esc_html__('Ajax load', 'genesisexpo-core') => "ajax",
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Pagination', 'genesisexpo-core'),
                'param_name' => 'show_pagination',
                'value' => array( esc_html__('Yes', 'genesisexpo-core') => 'yes' ),
                'std' => 'not',
                'dependency' => array(
                    'element' => 'view_style',
                    "value" => "standard"
                )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Navigation\'s Alignment', 'genesisexpo-core'),
                'param_name' => 'portfolio_navigation_align',
                'value' => array(
                    esc_html__('Center', 'genesisexpo-core') => 'center',
                    esc_html__('Left', 'genesisexpo-core') => 'left',
                    esc_html__('Right', 'genesisexpo-core') => 'right'
                ),
                'description' => esc_html__('Select Navigation\'s Alignment.', 'genesisexpo-core'),
                'std' => 'left',
                'dependency' => array(
                    'element' => 'show_pagination',
                    'value' => 'yes',
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Load More Button', 'genesisexpo-core'),
                'param_name' => 'show_loadmore',
                'value' => array( esc_html__('Yes', 'genesisexpo-core') => 'yes' ),
                'std' => 'not',
                'dependency' => array(
                    'element' => 'view_style',
                    "value" => "ajax"
                )
            ),                    
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Items on load', 'genesisexpo-core'),
                'param_name' => 'items_load',
                'value' => '4',
                'save_always' => true,
                'description' => esc_html__('Items load by load more button.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'show_loadmore',
                    "value" => "yes"
                )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Grid Gap', 'genesisexpo-core'),
                'param_name' => 'grid_gap',
                'admin_label' => true,
                'edit_field_class' => 'vc_col-sm-6',
                'value' => array(
                    esc_html__("0", 'genesisexpo-core') => '0px',
                    esc_html__("1", 'genesisexpo-core') => '1px',
                    esc_html__("2", 'genesisexpo-core') => '2px',
                    esc_html__("3", 'genesisexpo-core') => '3px',
                    esc_html__("4", 'genesisexpo-core') => '4px',
                    esc_html__("5", 'genesisexpo-core') => '5px',
                    esc_html__("10", 'genesisexpo-core') => '10px',
                    esc_html__("15", 'genesisexpo-core') => '15px',
                    esc_html__("20", 'genesisexpo-core') => '20px',
                    esc_html__("25", 'genesisexpo-core') => '25px',
                    esc_html__("30", 'genesisexpo-core') => '30px',
                    esc_html__("35", 'genesisexpo-core') => '35px',
                ),
                'std' => '30px',
            ),
            vc_map_add_css_animation( true ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Extra Class', 'genesisexpo-core'),
                'param_name' => 'item_el_class',
                'description' => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'genesisexpo-core')
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Click Item', 'genesisexpo-core'),
                'param_name' => 'click_area',
                'admin_label' => true,
                'group' => esc_html__('Content', 'genesisexpo-core'),
                'value' => array(
                    esc_html__("Single", 'genesisexpo-core') => 'single',
                    esc_html__("Popup", 'genesisexpo-core') => 'popup',
                    esc_html__("Default", 'genesisexpo-core') => 'none',
                ),
                'std' => 'popup',
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Show Info Position', 'genesisexpo-core'),
                'param_name' => 'info_position',
                'admin_label' => true,
                'value' => array(
                    esc_html__('Inside Image', 'genesisexpo-core') => 'inside_image',
                    esc_html__('Under Image', 'genesisexpo-core') => 'under_image',
                ),
                'std' => 'inside_image',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Inside Image Animation', 'genesisexpo-core'),
                'param_name' => 'image_anim',
                'value' => array(
                    esc_html__('Default', 'genesisexpo-core') => 'default',
                    esc_html__('Always Show Info', 'genesisexpo-core') => 'always_info',
                ),
                'group' => esc_html__('Content', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'info_position',
                    'value' => array('inside_image')
                )
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Horizontal Align', 'genesisexpo-core'),
                'param_name' => 'horizontal_align',
                'admin_label' => true,
                'value' => array(
                    esc_html__('Left', 'genesisexpo-core') => 'Left',
                    esc_html__('Center', 'genesisexpo-core') => 'center',
                    esc_html__('Right', 'genesisexpo-core') => 'right'
                ),
                'group' => esc_html__('Content', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'info_position',
                    'value' => array('under_image')
                )
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Content Elements', 'genesisexpo-core'),
                'param_name' => 'h_content_elements',
                'group' => esc_html__('Icon', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Title?', 'genesisexpo-core'),
                'param_name' => 'show_portfolio_title',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
                'std' => 'true',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Content?', 'genesisexpo-core'),
                'param_name' => 'show_content',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show author?', 'genesisexpo-core'),
                'param_name' => 'show_meta_author',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show categories?', 'genesisexpo-core'),
                'param_name' => 'show_meta_categories',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
                'std' => 'true',
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show date?', 'genesisexpo-core'),
                'param_name' => 'show_meta_date',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Likes?', 'genesisexpo-core'),
                'param_name' => 'show_likes',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),            
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Show Comments?', 'genesisexpo-core'),
                'param_name' => 'show_comments',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            // Content Letter Count
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Content Letter Count', 'genesisexpo-core'),
                'param_name' => 'content_letter_count',
                'value' => '85',
                'description' => esc_html__('Enter content letter count.', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Content', 'genesisexpo-core'),
            ),
            // Portfolio Headings Font
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom font family for Portfolio Headings', 'genesisexpo-core'),
                'param_name' => 'custom_fonts_portfolio_headings',
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_portfolio_headings',
                'value' => '',
                'settings' => array(
                    'fields' => array(
                        'font_family_description' => esc_html__('Select font family.', 'genesisexpo-core'),
                        'font_style_description' => esc_html__('Select font styling.', 'genesisexpo-core'),
                    ),
                ),
                'dependency' => array(
                    'element' => 'custom_fonts_portfolio_headings',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),

            // --- CAROUSEL GROUP --- //
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Carousel Options', 'genesisexpo-core'),
                'param_name' => 'h_portfolio_carousel',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
            ),
            array(
                "type" => "wgl_checkbox",
                'heading' => esc_html__('Autoplay', 'genesisexpo-core'),
                "param_name" => "autoplay",
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            array(
                "type" => "textfield",
                "heading" => esc_html__('Autoplay Speed', 'genesisexpo-core'),
                "param_name" => "autoplay_speed",
                "dependency" => array(
                    "element" => "autoplay",
                    "value" => 'true'
                ),
                'edit_field_class' => 'vc_col-sm-4',
                "value" => "3000",
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Multiple Items', 'genesisexpo-core'),
                'param_name' => 'multiple_items',
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Pagination Controls', 'genesisexpo-core'),
                'param_name' => 'h_pag_controls',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Pagination control', 'genesisexpo-core'),
                'param_name' => 'use_pagination',
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
                'std' => 'true'
            ),
            array(
                'type' => 'genesisexpo_radio_image',
                'heading' => esc_html__('Pagination Type', 'genesisexpo-core'),
                'param_name' => 'pag_type',
                'fields' => array(
                    'circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle.png',
                        'label' => esc_html__('Circle', 'genesisexpo-core')),
                    'circle_border' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_circle_border.png',
                        'label' => esc_html__('Empty Circle', 'genesisexpo-core')),
                    'square' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_square.png',
                        'label' => esc_html__('Square', 'genesisexpo-core')),
                    'line' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line.png',
                        'label' => esc_html__('Line', 'genesisexpo-core')),
                    'line_circle' => array(
                        'image_url' => get_template_directory_uri() . '/img/wgl_composer_addon/icons/pag_line_circle.png',
                        'label' => esc_html__('Line - Circle', 'genesisexpo-core')),
                ),
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
                'value' => 'circle',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Pagination Top Offset', 'genesisexpo-core'),
                'param_name' => 'pag_offset',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
                'description' => esc_html__('Enter pagination top offset in pixels.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Pagination Color', 'genesisexpo-core'),
                'param_name' => 'custom_pag_color',
                'edit_field_class' => 'vc_col-sm-4',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'use_pagination',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Pagination Color', 'genesisexpo-core'),
                'param_name' => 'pag_color',
                'value' => $theme_color,
                'dependency' => array(
                    'element' => 'custom_pag_color',
                    'value' => 'true'
                ),
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-4',
            ),
            // carousel pagination heading
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Responsive', 'genesisexpo-core'),
                'param_name' => 'h_resp',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Customize Responsive', 'genesisexpo-core'),
                'param_name' => 'custom_resp',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => 'carousel'
                ),
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
            ),
            // medium desktop
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Medium Desktop', 'genesisexpo-core'),
                'param_name' => 'h_resp_medium',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_medium',
                'value' => '1025',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_medium_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            
            // tablets
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Tablets', 'genesisexpo-core'),
                'param_name' => 'h_resp_tablets',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_tablets',
                'value' => '800',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_tablets_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            // mobile phones
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Mobile Phones', 'genesisexpo-core'),
                'param_name' => 'h_resp_mobile',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Screen resolution', 'genesisexpo-core'),
                'param_name' => 'resp_mobile',
                'value' => '480',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Slides to show', 'genesisexpo-core'),
                'param_name' => 'resp_mobile_slides',
                'value' => '',
                'group' => esc_html__('Carousel', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
                'dependency' => array(
                    'element' => 'custom_resp',
                    'value' => 'true',
                ),
            ),

            // --- CUSTOM GROUP --- //
            // Portfolio Font
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom font family for Portfolio Content', 'genesisexpo-core'),
                'param_name' => 'custom_fonts_portfolio_content',
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            array(
                'type' => 'google_fonts',
                'param_name' => 'google_fonts_portfolio',
                'value' => '',
                'settings' => array(
                    'fields' => array(
                        'font_family_description' => esc_html__('Select font family.', 'genesisexpo-core'),
                        'font_style_description' => esc_html__('Select font styling.', 'genesisexpo-core'),
                    ),
                ),
                'dependency' => array(
                    'element' => 'custom_fonts_portfolio_content',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom styles for Portfolio', 'genesisexpo-core'),
                'param_name' => 'custom_portfolio_style',
                'description' => esc_html__('Custom portfolio font size and font color.', 'genesisexpo-core'),
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            // Custom portfolio style
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Custom Main Color', 'genesisexpo-core'),
                'param_name' => 'custom_main_color',
                'value' => esc_attr(GenesisExpo_Theme_Helper::get_option('theme-custom-color')),
                'description' => esc_html__('Select custom main color.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),            
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Custom Filter Color', 'genesisexpo-core'),
                'param_name' => 'custom_filter_color',
                'value' => esc_attr(GenesisExpo_Theme_Helper::get_option('theme-custom-color')),
                'description' => esc_html__('Select custom filter color.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Custom Headings Color', 'genesisexpo-core'),
                'param_name' => 'custom_headings_color',
                'value' => esc_attr($header_font['color']),
                'description' => esc_html__('Select custom headings color.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'colorpicker',
                'class' => '',
                'heading' => esc_html__('Custom Content Color', 'genesisexpo-core'),
                'param_name' => 'custom_content_color',
                'value' => esc_attr($main_font['color']),
                'description' => esc_html__('Select custom content color.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Heading Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Heading Font Size', 'genesisexpo-core'),
                'param_name' => 'heading_font_size',
                'value' => '30',
                'description' => esc_html__('Enter heading font-size in pixels.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // Heading Font Size
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Content Font Size', 'genesisexpo-core'),
                'param_name' => 'content_font_size',
                'value' => '16',
                'description' => esc_html__('Enter content font-size in pixels.', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'custom_portfolio_style',
                    'value' => 'true'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'save_always' => true,
                'edit_field_class' => 'vc_col-sm-6',
            ),
           array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('Overlay settings', 'genesisexpo-core'),
                'param_name' => 'h_content_overlay',
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            array(
                'type' => 'dropdown',
                'heading' => esc_html__('Background Customize Colors', 'genesisexpo-core'),
                'param_name' => 'bg_color_type',
                'value' => array(
                    esc_html__('None', 'genesisexpo-core') => 'none',
                    esc_html__('Color', 'genesisexpo-core') => 'color',
                    esc_html__('Gradient', 'genesisexpo-core') => 'gradient',
                ),
                'std' => 'color',
                'group' => esc_html__('Font', 'genesisexpo-core'),
            ),
            // background color
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Color', 'genesisexpo-core'),
                'param_name' => 'background_color',
                'value' => 'rgba('.GenesisExpo_Theme_Helper::HexToRGB($theme_color_second).', 0.9)',
                'description' => esc_html__('Select background color', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'color'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient start
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background Start Color', 'genesisexpo-core'),
                'param_name' => 'background_gradient_start',
                'value' => 'rgba('.GenesisExpo_Theme_Helper::HexToRGB($theme_gradient_start).', 0.85)',
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            // background Gradient end
            array(
                'type' => 'colorpicker',
                'heading' => esc_html__('Background End Color', 'genesisexpo-core'),
                'param_name' => 'background_gradient_end',
                'value' => 'rgba('.GenesisExpo_Theme_Helper::HexToRGB($theme_gradient_end).', 0.85)',
                'dependency' => array(
                    'element' => 'bg_color_type',
                    'value' => 'gradient'
                ),
                'group' => esc_html__('Font', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
                'type' => 'genesisexpo_param_heading',
                'heading' => esc_html__('First Item', 'genesisexpo-core'),
                'param_name' => 'h_content_overlay',
                'edit_field_class' => 'vc_col-sm-12 no-top-margin',
                'group' => esc_html__('First Item', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => array('masonry4')
                ),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Custom First Item', 'genesisexpo-core'),
                'param_name' => 'add_first_item',
                'dependency' => array(
                    'element' => 'portfolio_layout',
                    'value' => array('masonry4')
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Title', 'genesisexpo-core'),
                'param_name' => 'title',
                'dependency' => array(
                    'element' => 'add_first_item',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Subtitle', 'genesisexpo-core'),
                'param_name' => 'subtitle',
                'dependency' => array(
                    'element' => 'add_first_item',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
            ),
            array(
                'type' => 'textfield',
                'heading' => esc_html__('Background Title', 'genesisexpo-core'),
                'param_name' => 'bgtitle',
                'dependency' => array(
                    'element' => 'add_first_item',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
            ),
            array(
                'type' => 'textarea_html',
                'holder' => 'div',
                'heading' => esc_html__('Content.', 'genesisexpo-core') ,
                'param_name' => 'content',
                'dependency' => array(
                    'element' => 'add_first_item',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
            ),
            array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Add Button', 'genesisexpo-core'),
                'param_name' => 'add_button',
                'dependency' => array(
                    'element' => 'add_first_item',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
            array(
				'type' => 'textfield',
				'heading' => esc_html__('Button Text', 'genesisexpo-core'),
				'param_name' => 'button_title',
				'group' => esc_html__('First Item', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'add_button',
                    'value' => 'true'
                ),
			),
			// Link
			array(
				'type' => 'vc_link',
				'heading' => esc_html__('Button Link', 'genesisexpo-core'),
				'param_name' => 'link',
				'group' => esc_html__('First Item', 'genesisexpo-core'),
                'dependency' => array(
                    'element' => 'add_button',
                    'value' => 'true'
                ),
				'description' => esc_html__('Add link to button.', 'genesisexpo-core')
			),
			array(
                'type' => 'wgl_checkbox',
                'heading' => esc_html__('Custom Button Colors', 'genesisexpo-core'),
                'param_name' => 'custom_button',
                'dependency' => array(
                    'element' => 'add_button',
                    'value' => 'true'
                ),
                'group' => esc_html__('First Item', 'genesisexpo-core'),
                'edit_field_class' => 'vc_col-sm-12',
            ),
			// Button text-color header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Text Color', 'genesisexpo-core'),
				'param_name' => 'h_text_color',
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'color'
				),
			),
			// Button text-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Text Color', 'genesisexpo-core'),
				'param_name' => 'button_text_color',
				'value' => '#313131',
				'description' => esc_html__('Select custom text color for button.', 'genesisexpo-core'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Hover text-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Text Color', 'genesisexpo-core'),
				'param_name' => 'button_text_color_hover',
				'value' => '#ffffff',
				'description' => esc_html__('Select custom text color for hover button.', 'genesisexpo-core'),
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true',
				),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Bg header
			array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Background Color', 'genesisexpo-core'),
				'param_name' => 'h_background_color',
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
			),
			// Button Bg
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Background', 'genesisexpo-core'),
				'param_name' => 'button_bg_color',
				'value' => '#ffffff',
				'description' => esc_html__('Select custom background for button.', 'genesisexpo-core'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Hover Bg
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Background', 'genesisexpo-core'),
				'param_name' => 'button_bg_color_hover',
				'value' => $theme_color_second,
				'description' => esc_html__('Select custom background for hover button.', 'genesisexpo-core'),
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'save_always' => true,
				'edit_field_class' => 'vc_col-sm-6',
            ),
            array(
				'type' => 'genesisexpo_param_heading',
				'heading' => esc_html__('Border Color', 'genesisexpo-core'),
				'param_name' => 'h_border_color',
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-12',
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
			),
			// Button border-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Border Color', 'genesisexpo-core'),
				'param_name' => 'button_border_color',
				'value' => $theme_color_second,
				'description' => esc_html__('Select custom border color for button.', 'genesisexpo-core'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'edit_field_class' => 'vc_col-sm-6',
			),
			// Button Hover border-color
			array(
				'type' => 'colorpicker',
				'class' => '',
				'heading' => esc_html__('Hover Border Color', 'genesisexpo-core'),
				'param_name' => 'button_border_color_hover',
				'value' => $theme_color_second,
				'description' => esc_html__('Select custom border color for hover button.', 'genesisexpo-core'),
				'group' => esc_html__('First Item', 'genesisexpo-core'),
				'save_always' => true,
				'dependency' => array(
					'element' => 'custom_button',
					'value' => 'true'
				),
				'edit_field_class' => 'vc_col-sm-6',
			),
        )
));
    GenesisExpo_Loop_Settings::init(
        $this->shortcodeName,
        array(
            'hide_cats' => true,
            'hide_tags' => true
        )
    );
}
